@extends('system.layout.main', [])
@section('title')
    <title>GMC FEED</title>
@endsection
@section('script')
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="/modules/ads/js/gmc-feed-report.js?v={{ config('sa.version') }}"></script>
@endsection

<style>
    .content {
        flex: 1;
        padding: 20px;
        display: flex;
        flex-direction: column;
    }

    .controls {
        display: flex;
        align-items: center;
        gap: 10px;
        margin-bottom: 20px;
    }

    .controls label {
        font-size: 16px;
    }

    .controls input[type="date"] {
        padding: 10px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .controls button {
        padding: 10px 20px;
        font-size: 14px;
        background-color: #4285f4;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    .controls button:hover {
        background-color: #357ae8;
    }

    .container-wrapper {
        display: flex;
        width: 100%;
        flex: 1;
    }

    .container {
        flex: 1;
        padding: 20px;
    }

    .second-container {
        flex: 1;
        padding: 20px;
    }

    label {
        font-size: 18px;
        margin-right: 10px;
    }
</style>
@section('content')
    <div class="content">
        <div class="controls">
            <label for="startDate">Từ ngày</label>
            <input type="date" id="startDate" name="startDate">
            <label for="endDate">đến ngày</label>
            <input type="date" id="endDate" name="endDate">
            <button onclick="loadChartData(event, '/module/ads/merchant-product-state')">Xem thống kê</button>
        </div>
        <div class="container-wrapper">
            <div class="container">
                <div id="container" style="margin-top: 20px;"></div>
            </div>
            <div class="second-container">
                <div id="second-container" style="margin-top: 20px;"></div>
            </div>
            <div class="second-container">
                <div id="three-container" style="margin-top: 20px;"></div>
            </div>
        </div>
    </div>
@endsection
