@extends('system.layout.main', [
    'ngController' => 'ProductIncorrectLanguageController'
])
@section('title')
    <title>Incorrect language</title>
@endsection
@section('content')
    <style>
        .mt-2-5 {
            margin-top: 10px;
        }
        .w-50\% {
            width: 50%;
        }
    </style>
    <div class="content" ng-cloak>
        <div class="header">
            <div class="pull-left">
                <h3 class="">Incorrect language</h3>
            </div>
            <div class="clearfix">
            </div>
        </div>
        <br>
        <div class="body">
            <div class="box no-border">
                <div class="box-body">
                    <div>
                        <ul class="nav nav-tabs ml-auto">
                            <li class="nav-item" ng-class="{active: item.active === true}"
                                ng-repeat="item in tabs">
                                <a data-toggle="tab" class="nav-link" href="#@{{ item.type }}">
                                    @{{ item.name }}
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div id="list" class="tab-pane fade in active">
                            @view('system.incorrect-language.filter')
                            @view('system.incorrect-language.list')
                            <div class="box-footer clearfix">
                                @include('system.pagination')
                            </div>
                        </div>
                        <div id="import" class="tab-pane fade">
                            <form method="POST" action="{{ route('incorrect-language::classify-data') }}"
                                  enctype="multipart/form-data" class="mt-2-5">
                                <input type="hidden" name="token" value="VVCTTQUhXuPCKYu">
                                <input type="file" name="csv_file"> <br>
                                <button type="submit">Upload CSV</button>
                            </form>
                        </div>
                        <div id="translation" class="tab-pane fade">
                            <div class="mt-2-5">
                                <button type="button" ng-click="startTranslating()">Translate</button>
                            </div>
                            <div class="mt-2-5">
                                Translated incorrect language products: @{{ translated }}
                            </div>
                        </div>
                        <div id="update" class="tab-pane fade">
                            <div class="mt-2-5">
                                <button type="button" ng-click="startUpdateToProduct()">Update to product</button>
                            </div>
                            <div class="mt-2-5">
                                Updated incorrect language products: @{{ updated }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        let moduleLocales = <?=  json_encode(getModuleLocale()); ?>;
        const currentLocale = '<?= !empty(env('APP_LOCALE')) ? env('APP_LOCALE') : 'us' ?>';
        const PODLocales = moduleLocales.map((item) => {
            return {
                code: item.locale,
                name: item.name,
                redirectAdmin: item.redirectAdmin,
            };
        });
    </script>
    <script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
    <script src="/modules/ads/controllers/product-incorrect-language-controller.js?v={{ config('sa.version') }}"></script>
@endsection