@extends('system.layout.main', [])
@section('title')
    <title>Sản phẩm PENDING</title>
@endsection
@section('content')

<link rel="stylesheet" href="@asset('ads/css/pending-product.css')?v=<?= Config::get("sa.version") ?>">

<div class="content" ng-controller="PendingProductController">
    <div class="row">
        <div class="col-md-12">
            <div class="action-header" style="margin-bottom: 20px; margin-top: 35px">
                <h4>Sản phẩm PENDING</h4>
            </div>
        </div>
        <div class="col-md-12">
            <div class="box no-border">
                <div class="box-body">
                    <div>
                        <div style="padding: 8px">
                            <strong>
                                Nhân viên +  số sản phẩm Pending:
                            </strong>
                        </div>
                        <div style="display: flex;">
                            <table class="table table-bordered table-hover" style="max-width: 500px">
                                <tr ng-repeat="staff in staffProductCount" ng-click="chooseStaff(staff)">
                                    <td>@{{ staff.name }}</td>
                                    <td><span class="badge badge-light">@{{ staff.count }}</span></td>
                                </tr>
                            </table>
                            <table class="table table-bordered table-hover" style="max-width: 500px">
                                <tr ng-repeat="staff in staffProductCountSecond" ng-click="chooseStaff(staff)">
                                    <td>@{{ staff.name }}</td>
                                    <td><span class="badge badge-light">@{{ staff.count }}</span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    @include('ads::pending-product.filter')
                    <table class="table" id="tableProduct">
            
                        
            
                        <tr ng-show="states.isLoading">
                            <td colspan="3" style="padding: 50px; height: 180px">
                                <div class="loader">
                                    <div class="inner one"></div>
                                    <div class="inner two"></div>
                                    <div class="inner three"></div>
                                </div>
                            </td>
                        </tr>
            
                        
            
                        <tr ng-show="!states.isLoading">
                            <th>Tiêu đề SP</th>
                            <th colspan="2">Note</th>
                            <th colspan="2">Người tạo</th>
                        </tr>
                       
                        <tr class="product-item" ng-repeat="product in products track by $index">
                            <td>
                                    <a target="_blank" href="/product-p@{{ product.product_id }}">@{{ product.title }}</a>
                            </td>
                            <td>
                                <span>@{{ product.note }}</span>
                            </td>
                            <td colspan="2" class="">
                                @{{ product.user_name }}
                            </td>
                        </tr>
                        <tr ng-show="!states.isLoading && !products.length">
                            <td colspan="3" style="padding: 60px; text-align: center; height: 180px">
                                <p>Không tìm được sản phẩm thỏa mãn</p>
                            </td>
                        </tr>
                        
                    </table>
            
                    <nav style="padding: 15px" ng-if="productPagination.number_page > 1">
                        <ul class="pagination" style="margin:0">
            
                            <li ng-repeat="n in range(productPagination.current_page - 4, productPagination.current_page - 1)" 
                                ng-if="n > 0"
                                class="page-item">
                                <a ng-click="productPagination.current_page = n; getProducts();" class="page-link" href="#">@{{ n }}</a>
                            </li>
                            <li class="page-item active"><a class="page-link" href="#">@{{ productPagination.current_page }}</a></li>
                            <li ng-repeat="n in range(productPagination.current_page + 1, productPagination.current_page + 4)" 
                                ng-if="n <= productPagination.number_page"
                                class="page-item">
                                <a ng-click="productPagination.current_page = n; getProducts();" class="page-link" href="#">@{{ n }}</a>
                            </li>
                        </ul>
                    </nav>
                </div>
                
                  
            </div>
        </div>
        
    </div>
    

</div>

@endsection


@section('script')

    <script>
        window.staffs = {!! json_encode($staffs) !!};
        window.userId = {!! auth()->user()->id !!};
    </script>

    <script src="@asset('ads/js/moment.min.js')"></script>
    <script src="@asset('ads/controllers/pending-product-controller.js')?v=<?= Config::get("sa.version") ?>"></script>
@endsection