@extends('system.layout.main', [
'ngController' => 'ProductToAdvertiseController'
])
@section('title')
<title>Sản phẩm cần quảng cáo</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Tìm kiếm sản phẩm</span>
                @view('system.product-advertise.filters')
                @view('system.product-advertise.lists')
                @view('system.includes.paginator', [
                    "accessPageId" => "filters.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    var accounts = <?= json_encode($accounts) ?>;
    var categories = <?= json_encode($categories) ?>;
</script>
<script src="/modules/ads/js/product-to-advertise.module.controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/ads/css/product-activities.css?v=<?= time() ?>" />
@endsection