<div class="interaction-module-list-wrapper">
    <span class="module-title">Danh sách sản phẩm</span>
    <table class="interaction-module-list-table">
        <thead class="product-advertise-head">
            <tr>
                <th class="w-20">#</th>
                <th class="w-200">Mã sản phẩm</th>
                <th class="w-200">Tên sản phẩm</th>
                <th class="col-w70">Tồn kho</th>
                <th class="col-w70">Trạng thái</th>
                <th class="col-w70">Trạng thái Feed</th>
                <th class="col-w70">Clicks</th>
                <th class="w-200">Thông tin Ads</th>
            </tr>
            <tr ng-show="isShowLoading">
                <div class="loading" ng-show="isShowLoading">
                    <div class="loading_line_wrapper">
                        <div class="loading_line">
                            <div class="loading_line_inner loading_line_inner--1"></div>
                            <div class="loading_line_inner loading_line_inner--2"></div>
                        </div>
                    </div>
                </div>
            </tr>
        </thead>
        <tbody class="product-advertise-body">
        
            <tr ng-repeat="item in items">
                <td>@{{$index + 1}}</td>
                <td>@{{item.sku}}</td>
                <td><a href="@{{item.link}}" target="_blank">@{{item.title}}</a></td>
                <td class="col-w70">@{{item.inventory}}</td>
                <td>
                    @{{getByCode(statuses,item.status).name}}
                </td>
                <td>
                    <span ng-if="item.is_push_merchant_feed">Đã lên feed</span>
                    <span ng-if="!item.is_push_merchant_feed">Chưa lên feed</span>
                </td>
                <td class="product-advertise-total col-w70">
                    <p>Tổng: @{{item.click}}</p>
                    <p ng-repeat="campaign in item.click_campaign_types">
                        <span qtip qtip-text="@{{campaign.detail}}" style="cursor: pointer; white-space: no-wrap">@{{campaign.campaign_type}}: @{{campaign.click}}</span>
                    </p>
                </td>
                <td>
                    <div class="scroll-x scrollbar product-advertise-wrapper" ng-if="item.data.length > 0">
                        <div class="product-advertise-content" ng-repeat="info in item.data">
                            <ul>
                                <li class="ads-info-item flex-b" ng-repeat="(key, value) in info">
                                    <span class="item-key">@{{key}}:</span>
                                    <span class="item-value">
                                        <span ng-if="key != 'ad_status' && key != 'campaign_status'">
                                            @{{value}}
                                        </span>
                                        <b ng-if="(key == 'ad_status' && value == 'enabled') || (key == 'campaign_status' && value == 'enabled')" style="color: green; text-transform: uppercase;">
                                            @{{value}}
                                        </b>
                                        <b ng-if="(key == 'ad_status' && value == 'paused') || (key == 'campaign_status' && value == 'paused')" style="color: red; text-transform: uppercase;">
                                            @{{value}}
                                        </b>
                                    </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>
    </table>
</div>