@extends('system.layout.main', [
    'ngController' => 'ProductCategoryActivitiesController'
])
@section('title')
<title>Báo cáo tương tác sản phẩm so với danh mục</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Báo cáo tương tác sản phẩm</span>
                @view('system.product-category.filters')
                @view('system.product-category.lists')
                @view('system.includes.paginator', [
                    "accessPageId" => "filter.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
            </div>
        </div>
    </div>
</div>
@endsection
@section('script')
<script>
    var onlyProduct = <?= (\Config::get('ads::ads.is_group', '')) ? 1 : 0 ?>;
    var base_url = '<?= url( env('APP_LOCALE', '/'))  ?>/' ;
</script>
<script src="/modules/ads/controllers/product-category-react.module.controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/ads/css/product-activities.css?v=<?= time() ?>" />
@endsection