@extends('system.layout.main', [])
@section('title')
<title>Cập nhật giá SP</title>
@endsection
@section('content')

@section('script')
    <script src="/system/js/scripts/jquery-csv.min.js"></script>
    <script src="/system/js/scripts/xlsx.full.min.js"></script>
    <script src="{{ Module::asset('ads/controllers/product-price-controller.js') }}?v={{ config('app.version') }}"></script>
@endsection

<div class="content" ng-controller="ProductPriceController">
    <div class="header">
        <div class="pull-left">
            <h3 class="">Cập nhật giá SP</h3>
        </div>
        <div class="clearfix">
        </div>
    </div>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <div class="row">
                    <div class="col-md-1">
                        <label for="">Chọn file</label>
                    </div>
                    <div class="col-md-11">
                        <input type="file" ngf-select="loadFile($files)">
                    </div>
                </div>
                <div class="row mt-3" style="min-height: 350px; max-height: 350px; height: 350px" ng-show="logs.length > 0">
                    <div class="col-md-12">
                        <p ng-repeat="log in logs track by $index">@{{ log }}</p>
                    </div>
                    <div class="col-md-12">
                        <p>Thành công: @{{ successCount }} | Lỗi: @{{ errorCount }}</p>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col-md-12">
                        <button class="btn btn-primary" ng-disabled="saving" ng-click="update()">
                            <span ng-if="saving">
                                <i class="fa fa-refresh fa-spin" ></i>
                            </span>
                            @{{ btnText }}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection