@extends('system.layout.main', [
'ngController' => 'ProductInteractionController'
])
@section('title')
<title>Báo cáo tương tác sản phẩm</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Báo cáo tương tác sản phẩm </span>
                @view('system.product-react.filters')
                @view('system.product-react.lists')
                @view('system.includes.paginator', [
                    "accessPageId" => "filter.page_id",
                    "accessPagesCount" => "pagesCount",
                    "accessFind" => "find()"
                ])
                @include('ads::product-react.modal.advertising-global')
                @include('ads::product-react.modal.advertising-product')
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    var base_api_url = '<?= \Config::get('ads::ads.base_api_url', ''); ?>';
    var onlyProduct = <?= (\Config::get('ads::ads.is_group', '')) ? 1 : 0 ?>;
    var base_url = '<?= url( env('APP_LOCALE', '/'))  ?>' ;

</script>
<script src="/modules/ads/controllers/product-react.module.controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="/modules/ads/css/product-activities.css?v=<?= time() ?>" />
@endsection