@extends('system.layout.main', [
    'ngController' => 'ProductSoldOffAdsController'
])
@section('title')
<title>Sản phẩm có đơn đang tắt quảng cáo</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <h2 class="header">Danh sách SP có đơn đang tắt quảng cáo</h2>
        <div class="form-inline" style="background-color: #fff; padding: 8px; margin-bottom: 8px; border-radius: 4px">
            <div class="form-group">
                <div class="input-group">
                    <span class="input-group-addon">Từ <span class="hidden-xs">ngày</span></span>
                    <input type="text" my-date-picker ng-model="filter.orderDateFrom" 
                        class="form-input form-control datepicker" autocomplete="off"/>
                    <span class="input-group-addon">đến <span class="hidden-xs">ngày</span></span>
                    <input type="text" my-date-picker ng-model="filter.orderDateTo"
                        class="form-input form-control datepicker" autocomplete="off"/>
                </div>
            </div>

            <div class="form-group">
                <div class="input-group">
                    <span class="input-group-addon">Trạng thái</span>
                    <select class="form-control" ng-model="filter.status">
                        <option value="-1">Tất cả</option>
                        <option value="0">Bị từ chối khi duyệt tự động</option>
                    </select>
                </div>
                <div class="input-group">
                    <span class="input-group-addon">Tên sản phẩm</span>
                    <input ng-keyUp="$event.keyCode === 13 && find(true)" type="text" class="form-control" ng-model="filter.keyword">
                </div>
            </div>

            <div class="form-group text-center">
                <button type="button" class="btn btn-primary" ng-disabled="loading" ng-click="find()">
                    <span ng-if="loading">
                        <i class="fa fa-spinner fa-pulse fa-fw"></i>
                    </span> 
                    <i class="fa fa-search" ng-if="!loading"></i>
                    Tìm kiếm
                </button>
                <button type="button" class="btn btn-default" ng-click="reset()">
                    <i class="fa fa-times"></i> Xóa form
                </button>
            </div>
            
        </div>
        <div class="box no-border">
            <div class="box-body">
                <table class="table">
                   <tr ng-show="countSelectedQuantity == 0">
                        <th>
                            <input type="checkbox" name="" id="" ng-model="isSelectAll" ng-change="selectAll()" >
                            ID
                        </th>
                        <th>Name</th>
                        <th>Actor email</th>
                        <th>Sold</th>
                        <th>Action</th>
                   </tr>
                   <tr ng-show="countSelectedQuantity > 0">
                        <th>
                            <input type="checkbox" name="" id="" ng-model="isSelectAll" ng-change="selectAll()" >
                            <span>@{{ countSelectedQuantity }} products</span>
                        </th>
                        <th>
                            <button class="btn btn-success" ng-click="onChangeApproveAdvertisingAll()">Duyệt tất cả</button>
                        </th>
                   </tr>
                   <tr ng-repeat="product in products">
                        <td>
                            <input type="checkbox" name="" id="" ng-disabled="product.isApprove" ng-checked="product.selected" ng-model="product.selected" ng-change="selectProduct(product, product.selected)" >
                            @{{ product.id }}
                        </td>
                        <td>
                            <a href="@{{ productUrl(product) }}" target="_blank">
                                @{{ product.name }}
                            </a>
                        </td>
                        <td>
                            @{{ product.actor_email }}
                        </td>
                       <td>
                           @{{ product.sold }}
                       </td>
                        <td>
                            <button class="@{{ product.className }}" ng-click="onChangeApproveAdvertising(product)" ng-disabled="product.isApprove">@{{ product.textBtn }}</button>
                        </td>
                   </tr>
                </table>

                <div class="text-center">
                    <button ng-disabled="loading" class="btn btn-primary" ng-if="pagination.current_page < pagination.last_page" ng-click="changePage(pagination.current_page + 1)">Load More</button>
                </div>

                <div class="clearfix">
                    <div class="pull-right">
                        @include('warehouse-pod::system.includes.paginator', [
                            "accessPageId" => "filter.page_id",
                            "accessPagesCount" => "pagesCount",
                            "accessFind" => "find()"
                        ])
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
    var base_api_url = '{{ config("sa.api_url") }}';
    var onlyProduct = <?= (\Config::get('ads::ads.is_group', '')) ? 1 : 0 ?>;
    var base_url = '<?= url( env('APP_LOCALE', '/'))  ?>' ;

</script>
<script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
<script src="/modules/ads/controllers/product-sold-offads.controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<style>

    :root {
    --primary: #095098;
    --primary-dk: #037f00;
    --primary-lt: #59bc33;
    --secondary: #ff7300;
    --secondary-dk: #fc0a03;
    --secondary-lt: #ff8f28;
    --link: #0087cd;
    --link-hover: #fa8128;
    --white: #fff;
    --light: #f5f5f5;
    --flash: #e1e1e1;
    --gray: #a1a1a1;
    --dark: #999;
    --darkness: #444;
    --black: #111;
    --shadow: rgba(11, 11, 11, 0.1);
    --trans: all 350ms ease-in-out;
    --s-number: 6px;
    --m-number: 12px;
    --l-number: 24px;
}

    /* pagination */
.pagination-box {
    margin: var(--m-number) auto var(--m-number);
    padding-top: var(--m-number);
    display: flex;
    justify-content: flex-start;
    align-content: center;
}

.pagination {
    margin: 0;
    padding: 0;
    list-style: none;
    display: flex;
    justify-content: flex-start;
    align-items: center;
}

.pagination li {
    display: flex;
    justify-content: center;
    align-items: center;
    margin-right: var(--s-number);
    background-color: #efefef;
    border-radius: 3px;
    user-select: none;
    cursor: pointer;
    padding: calc(var(--m-number) - 4px) var(--m-number);
    line-height: 1;
}

.pagination li:hover {
    color: var(--primary);
}

.pagination .disable {
    display: none;
}

.pagination .active {
    color: var(--dark);
    cursor: pointer;
    pointer-events: none;
}

.pagination .disable {
    background-color: var(--dark);
    color: var(--white);
    cursor: default;
    pointer-events: none;
}    
</style>
@endsection
