@extends('system.layout.main', [
    'ngController' => 'ProductWarningController'
])
@section('title')
    <title>Báo cáo sản phẩm</title>
@endsection
@section('content')
<div class="content" ng-cloak>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <span class="module-title">Tìm kiếm</span>
                @include('ads::product-warning.filters')
                @include('ads::product-warning.list')
                <div class="pull-right">
                    @view('system.includes.paginator', [
                        "accessPageId" => "filters.page_id",
                        "accessPagesCount" => "pagesCount",
                        "accessFind" => "find()"
                    ])
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script src="/modules/ads/controllers/product-warning-controller.js?v=<?= time() ?>"></script>
@endsection
@section('css')
<link rel="stylesheet" type="text/css" href="{{ Module::asset('ads/css/product-warning.css') . '?v=' . Config::get('sa.version') }}" />
@endsection