@extends('system.layout.main', [])
@section('title')
<title>Cài đặt Quảng cáo</title>
@endsection
@section('content')

@section('script')
<script>
    system.controller("AdsSettingController", AdsSettingController);

    function AdsSettingController($scope, $http, $rootScope, Upload) {
        $scope.types = [{code:'facebook',value:'Facebook'}]
        $scope.type = $scope.types[0];
        $scope.paths = [];

        $scope.initialize = async function() {
        $scope.find();
            toastr.options = {
                "debug": false,
                "positionClass": "toast-bottom-right",
                "onclick": null,
                "fadeIn": 300,
                "fadeOut": 1000,
                "timeOut": 5000,
                "extendedTimeOut": 1000
            };
        };


        $scope.handleUpload = function (csvFile) {
            if (csvFile) {
                Upload.upload({
                    url: '/ads/facebook/import-cost',
                    data: {file: csvFile}
                }).then(function (response) {
                    toastr.success('Import success');
                    $scope.find();
                }, function (error) {
                    toastr.error('Có lỗi xảy ra trong quá trình Import. Xin vui lòng thử lại.');
                });
            }
        }
        $scope.find = function (){
            $http.get('/ads/history-upload').then(function (response) {
                $scope.paths = response.data.reverse();
            });
        }

        $scope.initialize();
    }
</script>
@endsection

<style>
    fieldset.scheduler-border {
        border: 1px dashed #dedede !important;
        padding: 0 1.1em 1.1em 1.1em !important;
        margin: 0 0 1.5em 0 !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border {
        font-size: 1em !important;
        text-align: left !important;
        width: auto;
        padding: 0 10px;
        border-bottom: none;
    }

    legend {
        font-size: inherit;
        line-height: inherit;
        color: #666;
        margin-bottom: 10px;
    }
</style>

<div class="content" ng-controller="AdsSettingController">
    <div class="header">
        <div class="pull-left">
            <h3 class="">Cập nhật chi phí quảng cáo</h3> <a target="_blank" href="https://docs.google.com/document/d/1BobrY9LuSB6BwIGWyR9SBYR6EsqDMv-BoEzIHUHPwoY/edit"> Hướng dẫn</a>
        </div>
        <div class="clearfix">
        </div>
    </div>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <form action="">
                    <div class="form-group">
                        <label>Loại phí quảng cáo</label>
                            <select class="form-control"
                                    ng-model="type"
                                    ng-options="type.value for type in types track by type.code">
                            </select>
                    </div>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary" ngf-select ng-model="csvFile" ng-change="handleUpload(csvFile)" accept=".csv" ngf-max-size="5MB" ><i class="fa fa-upload"></i> CSV File</button>
                    </div>
                </form>
            </div>
        </div>
        <div class="box no-border">
            <div class="box-body">
                Lịch sử upload
                <div style="max-height: 250px; overflow: scroll">
                    <div ng-repeat="path in paths"><a target="_blank" href="/files/import-ads-cost/@{{path}}">@{{path}}</a></div>
                </div>
            </div>
        </div>
    </div>

    @endsection