@extends('system.layout.main', [])
@section('title')
    <title>Size & Color Mapping</title>
@endsection
@section('content')

@section('script')
    <script>
        var generalConfig = {!! json_encode($generalConfig) !!};
    </script>
    <script src="@asset('ads/controllers/size-and-color-mapping-controller.js')?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
@endsection

<style>

    .loader, .loader:before, .loader:after {
        border-radius: 50%;
        width: 2.5em;
        height: 2.5em;
        -webkit-animation-fill-mode: both;
        animation-fill-mode: both;
        -webkit-animation: load7 1.8s infinite ease-in-out;
        animation: load7 1.8s infinite ease-in-out;
    }

    .loader {
        color: #5c5c5c;
        font-size: 10px;
        margin: 80px auto;
        position: relative;
        text-indent: -9999em;
        -webkit-transform: translateZ(0);
        -ms-transform: translateZ(0);
        transform: translateZ(0);
        -webkit-animation-delay: -0.16s;
        animation-delay: -0.16s;
    }

    .loader:before, .loader:after {
        content: '';
        position: absolute;
        top: 0;
    }

    .loader:before {
        left: -3.5em;
        -webkit-animation-delay: -0.32s;
        animation-delay: -0.32s;
    }

    .loader:after {
        left: 3.5em;
    }

    @-webkit-keyframes load7 {
        0%, 80%, 100% {
            box-shadow: 0 2.5em 0 -1.3em;
        }
        40% {
            box-shadow: 0 2.5em 0 0;
        }
    }

    @keyframes load7 {
        0%, 80%, 100% {
            box-shadow: 0 2.5em 0 -1.3em;
        }
        40% {
            box-shadow: 0 2.5em 0 0;
        }
    }

    fieldset.scheduler-border {
        border: 1px dashed #dedede !important;
        padding: 0 1.1em 1.1em 1.1em !important;
        margin: 0 0 1.5em 0 !important;
        -webkit-box-shadow: 0px 0px 0px 0px #000;
        box-shadow: 0px 0px 0px 0px #000;
    }

    legend.scheduler-border {
        font-size: 1em !important;
        text-align: right !important;
        width: auto;
        padding: 0 10px;
        border-bottom: none;
    }

    legend {
        font-size: inherit;
        line-height: inherit;
        color: #666;
        margin-bottom: 10px;
    }

    .chosen-container-single,
    .chosen-container-multi {
        width: 100% !important;
        min-width: 150px;
    }

    .chosen-container-single .chosen-single {
        /* height: auto !important; */
    }

    .chosen-container-single .chosen-single, .chosen-container-multi .chosen-choices {
        background: none;
        box-shadow: none;
        border-color: transparent;
    }

    .chosen-container-multi .chosen-choices li.search-field input[type=text] {
        color: #999;
        height: 24px;
    }

    .chosen-container-multi .chosen-choices li.search-choice {
        border: none;
    }

    .chosen-container-active .chosen-choices {
        border-color: #aaa;
    }

    .pagination {
        margin: 0;
        margin-left: 5px;
    }
</style>

<div class="content" ng-controller="SizeColorMappingController">
    <div class="body">
        <div class="box no-border">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="">Size & Color Mapping (<code>module::ads::size_color_map</code>)</h3>
                </div>
                <button type="button" name="button"
                    class="btn btn-success btn-flat pull-right add" 
                    style="margin-top: 15px; border-radius: 5px"
                    id="btnSaveMap"
                    ng-click="saveMap();mode = 'create'">
                    <i class="fa fa-save"></i>  <span style="margin-left: 5px">Xác nhận, Lưu Map</span>
                </button>
                <div class="clearfix">
                </div>
            </div>
            <div class="box-body">
                <fieldset class="scheduler-border">
                    <legend class="scheduler-border">Configs</legend>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <button class="btn btn-primary" id="autoMapColor" ng-click="autoMapColors()">Auto map color</button>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="inputSearch" style="font-weight: normal;">Search: </label>
                                <input id="inputSearch" ng-model="filters.search" ng-keyup="search()" type="text" class="form-control">
                            </div>
                            <div class="form-group">
                                <label style="font-weight: normal;">
                                    <input type="checkbox" ng-model="filters.hide_mapped" ng-change="filter()">
                                    Hide mapped item
                                </label>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <div class="rowx" style="display: flex">
                    <div class="flex-1" style="width: 50%">
                        <table id="colorMapping" class="mt-3 table table-bordered bordered table-condensed">
                            <tr>
                                <th>Variant Color</th>
                                <th>Standard Color
                                    <span data-toggle="tooltip" data-placement="top"
                                        title="Nên chọn tối đa 3 màu">
                                        <img src="@asset('ads/images/information.png')" width="11px">
                                    </span>
                                </th>
                                <th class="text-center">
                                    <i class="fa fa-lock"></i> Confirm 
                                    <span data-toggle="tooltip" data-placement="top"
                                        title="Xác nhận đã chính xác, giá trị Standard Color sẽ không thay đổi khi thực hiện auto map">
                                        <img src="@asset('ads/images/information.png')" width="11px">
                                    </span>
                                </th>
                            </tr>
                            <tr ng-repeat="variantColor in paginate(variantColors, colorMapPagination.page_size, colorMapPagination.current_page) track by $index">
                                <td>@{{ variantColor }}</td>
                                <td style="width: 280px">
                                    <select class="form-control" 
                                        data-color="@{{ variantColor }}"
                                        chosen
                                        multiple
                                        create-option-text="'Add'"
                                        persistent-create-option="true"
                                        create-option="createColor"
                                        skip-no-results="true" ng-model="colorMap[variantColor]"
                                        ng-change="changeColorMap()"
                                        ng-options="color for color in colors">
                                    </select>
                                </td>
                                <td class="text-center" style="width: 100px;">
                                    <input ng-model="colorConfirm[variantColor]" type="checkbox" ng-change="changeColorConfirm()">
                                </td>
                            </tr>
                        </table>
                        <div class="loader color">Loading...</div>
                        <nav aria-label="Page navigation example" ng-if="colorMapPagination.number_page > 1">
                            <ul class="pagination">

                                <li ng-repeat="n in range(colorMapPagination.current_page - 4, colorMapPagination.current_page - 1)" 
                                    ng-if="n > 0"
                                    class="page-item">
                                    <a ng-click="colorMapPagination.current_page = n" class="page-link" href="#">@{{ n }}</a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="#">@{{ colorMapPagination.current_page }}</a></li>
                                <li ng-repeat="n in range(colorMapPagination.current_page + 1, colorMapPagination.current_page + 4)" 
                                    ng-if="n <= colorMapPagination.number_page"
                                    class="page-item">
                                    <a ng-click="colorMapPagination.current_page = n" class="page-link" href="#">@{{ n }}</a>
                                </li>
                                {{-- <li class="page-item"><a class="page-link" href="#">Previous</a></li>
                                <li class="page-item"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item"><a class="page-link" href="#">Next</a></li> --}}
                            </ul>
                        </nav>
                    </div>
                    <div class="flex-1" style="width: 50%">
                        <table id="sizeMapping" class="mt-3 table table-bordered bordered table-condensed">
                            <tr>
                                <th>Variant Size</th>
                                <th>Standard Size
                                    {{-- <span data-toggle="tooltip" data-placement="top"
                                        title="Nên chọn tối đa 3 màu">
                                        <img src="@asset('ads/images/information.png')" width="11px">
                                    </span> --}}
                                </th>
                                {{-- <th class="text-center">Confirm 
                                    <span data-toggle="tooltip" data-placement="top"
                                        title="Xác nhận đã chính xác, giá trị Standard Color sẽ không thay đổi khi thực hiện auto map">
                                        <img src="@asset('ads/images/information.png')" width="11px">
                                    </span>
                                </th> --}}
                            </tr>
                            <tr ng-repeat="variantSize in paginate(variantSizes, sizeMapPagination.page_size, sizeMapPagination.current_page) track by $index">
                                <td>@{{ variantSize }}</td>
                                <td style="width: 280px">
                                    <select class="form-control" 
                                        data-color="@{{ variantSize }}"
                                        chosen
                                        multiple
                                        create-option-text="'Add'"
                                        persistent-create-option="true"
                                        create-option="createColor"
                                        skip-no-results="true" ng-model="sizeMap[variantSize]"
                                        ng-options="size for size in sizes">
                                    </select>
                                </td>
                                {{-- <td class="text-center" style="width: 100px;">
                                    <input ng-model="sizeConfirm[variantSize]" type="checkbox">
                                </td> --}}
                            </tr>
                        </table>
                        <div class="loader size">Loading...</div>
                        <nav aria-label="Page navigation example" ng-if="sizeMapPagination.number_page > 1">
                            <ul class="pagination">

                                <li ng-repeat="n in range(sizeMapPagination.current_page - 4, sizeMapPagination.current_page - 1)" 
                                    ng-if="n > 0"
                                    class="page-item">
                                    <a ng-click="sizeMapPagination.current_page = n" class="page-link" href="#">@{{ n }}</a>
                                </li>
                                <li class="page-item active"><a class="page-link" href="#">@{{ sizeMapPagination.current_page }}</a></li>
                                <li ng-repeat="n in range(sizeMapPagination.current_page + 1, sizeMapPagination.current_page + 4)" 
                                    ng-if="n <= sizeMapPagination.number_page"
                                    class="page-item">
                                    <a ng-click="sizeMapPagination.current_page = n" class="page-link" href="#">@{{ n }}</a>
                                </li>
                                {{-- <li class="page-item"><a class="page-link" href="#">Previous</a></li>
                                <li class="page-item"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item"><a class="page-link" href="#">Next</a></li> --}}
                            </ul>
                        </nav>
                    </div>
                </div>

                <hr>

            </div>
        </div>
    </div>
</div>

@endsection
