<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */

use Illuminate\Support\Facades\Route;
$middleware = config('app.system_auth_middleware');
if (!is_array($middleware)) {
    $middleware = [$middleware];
}
Route::middleware(array_merge(['web'], $middleware))
    ->prefix('ads')->group(function () {

    Route::get('/setting','HomeController@setting' )
        ->name('ads::general::settings');
    Route::post('/facebook/import-cost','HomeController@importFacebookCost' )
            ->name('ads::facebook::import-cost');
    Route::get('/history-upload','HomeController@getListFile' )
            ->name('ads::history-upload');
    Route::get('/shopping-feed','HomeController@shoppingFeed' )
        ->name('ads::shopping::feeds');
    Route::get('/page-feed','HomeController@pageFeed' )
        ->name('ads::page-feed');
    Route::get('/remarketing-feed', 'HomeController@remarketingFeed')
        ->name('ads::marketing-feed');
    Route::get('/merchant-category', 'HomeController@merchantCategory')
        ->name('ads::merchant-category');
    Route::get('/size-color-mapping', 'HomeController@sizeColorMapping')
        ->name('ads::size-color::mapping');
    
    Route::get('/advertising', 'HomeController@advertising')
        ->name('ads::setting::ads');

//    Route::get('/product-report', function() {
//
//    })->name('ads::product::report::ads');
    Route::post('/update-is-violation', 'HomeController@updateIsViolation');
    Route::post('/update-is-always-on-ads', 'HomeController@updateIsAlwaysOnAds');
    Route::get('approve-by-link', 'HomeController@approveByLink');
    Route::get('approve-products', 'HomeController@approveProducts');

    Route::get('/incorrect-language', 'HomeController@incorrectLanguage')
        ->name('incorrect-language::index');

    Route::get('/product-price', 'HomeController@productPrice')
        ->name('ads::product::price');
    
    Route::get('/product-run-ads', 'ProductRunAdsController@index')->name('ads::product-run-ads.index');
    Route::post('/product-run-ads', 'ProductRunAdsController@save');
    Route::get('/product-run-ads/find', 'ProductRunAdsController@find');
    Route::delete('/product-run-ads/{id}', 'ProductRunAdsController@delete');
    Route::post('/product-run-ads/bulk-delete', 'ProductRunAdsController@bulkDelete');
});

Route::prefix('ads/incorrect-language')->group(function () {
    Route::get('/find', ['uses' => 'IncorrectLanguageController@find'])
        ->name('incorrect-language::find');
    Route::post('/classify-data', ['uses' => 'IncorrectLanguageController@classifyData'])
        ->name('incorrect-language::classify-data');
    Route::post('/store-data', ['uses' => 'IncorrectLanguageController@storeData'])
        ->name('incorrect-language::store-data');
    Route::get('/update-to-product', ['uses' => 'IncorrectLanguageController@updateToProduct'])
        ->name('incorrect-language::update-to-product');
    Route::get('/translate', ['uses' => 'IncorrectLanguageController@translate'])
        ->name('incorrect-language::translate');
    Route::post('/translate-and-update-slug', ['uses' => 'IncorrectLanguageController@translateAndUpdateSlug'])
        ->name('incorrect-language::translate-and-update-slug');
});

## ROUTE GROUP FOR FUNCTION PRODUCT TO ADVERTISE ##
Route::group(['prefix' => 'product-advertise', 'middleware' => 'web'], function () {
    Route::get('cron/campaign', ['uses' => 'Cron\AdsController@cronCampaign']);
    Route::get('cron/product-advertising', ['uses' => 'Cron\AdsController@cronProductAdvertising']);
    Route::get('cron/product-to-advertising', ['uses' => 'Cron\AdsController@cronProductToAdvertising']);
    Route::get('cron/click', ['uses' => 'Cron\ClickController@cronClick']);
    Route::get('cron/calculate-product-report', ['uses' => 'Cron\ClickController@calculatingReportByProduct']);

    Route::get('cron/advertising/build', ['uses' => 'ProductController@buildProductAdvertising']);
    Route::get('cron/advertising-sku/build', ['uses' => 'ProductController@buildProductAdvertisingSku']);

    Route::post('cron/bulk-approve', ['uses' => 'Cron\AdsController@cronBulkApprove']);
    Route::post('cron/bulk-disapprove', ['uses' => 'Cron\AdsController@cronBulkDisapprove']);
    Route::get('cron/build-disapprove', ['uses' => 'Cron\AdsController@cronBuildProductDisapprove']);

    /* approve bulk product screen */
    Route::get('bulk-approve', 'BulkApproveProductController@showScreen')->name('ads::product::bulk-push');
    Route::post('approve-by-design', 'Cron\AutoApproveDesignController@approveByDesign');
    Route::post('approve-by-design-batch', 'Cron\AutoApproveDesignBatchController@approveDesignBatch');
    Route::post('cron/auto-approve-by-design', 'Cron\AutoApproveSellerProduct@autoApprove');
    Route::post('cron/auto-approve-product-has-order', 'Cron\AutoApproveProductHasOrder@autoApprove');
    Route::get('get-product', 'BulkApproveProductController@getProducts');
    Route::any('bulk-approve/log-push', 'BulkApproveProductController@logPush');

});

Route::group(['prefix' => 'product-advertise', 'middleware' => 'web'], function () {
    Route::get('cron/check-violation', ['uses' => 'Cron\ViolationController@checkViolation']);
    Route::any('cron/check-violation-tag', ['uses' => 'Cron\ViolationController@checkViolationTag']);
    Route::get('cron/recheck-violation', ['uses' => 'Cron\ViolationController@recheckViolation']);
    Route::get('check-violation/enable-violation', ['uses' => 'Cron\ViolationController@enableViolation']);
});

Route::group(['prefix' => 'product-advertise', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', ['uses' => 'ProductToAdvertiseController@index'])->name('product-to-advertise::home');
    Route::post('find', ['uses' => 'ProductToAdvertiseController@find']);
    Route::post('build-campaign-click', ['uses' => 'ProductToAdvertiseController@buildCampaignClick']);
    Route::get('export-excel', ['uses' => 'ProductToAdvertiseController@exportExcel']);
});

Route::group(['prefix' => 'ads/product-sold-off-ads', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', ['uses' => 'ProductSoldController@index'])->name('product-to-advertise::product-sold-off-ads');
    Route::post('/get-products', ['uses' => 'ProductSoldController@getSoldProductOffAds']);
});



## END OF ROUTE GROUP FOR PRODUCT TO ADVERTISE ##



## ROUTE GROUP FOR FUNCTION PRODUCT REACTION ##
Route::group(['prefix' => 'product-react', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/index', [
        'as' => 'product-react::home',
        'uses' => 'HomeController@index',
    ]);
    Route::get('/category', [
        'as' => 'product-react::category::home',
        'uses' => 'HomeController@productCategoryInteraction',
    ]);
});

Route::group(['prefix' => '/product-react/api', 'middleware' => 'example'], function() {
    Route::get('/product-low-rate', [
        'as' => 'product-react-api::product-low-rate',
        'uses' => 'Api\ApiProductReactService@productLowRate',
    ]);
});

Route::group(['prefix' => 'product-react/service', 'middleware' => 'example'], function() {
    Route::get('/cron/cron-product-react', [
        'as' => 'product-react::cron-product-react',
        'uses' => 'ProductReactBuilderService@cronProductReact',
    ]);

    Route::get('/cron/cron-product-react-by-source', [
        'as' => 'product-react::cron-product-react-by-source',
        'uses' => 'Cron\ProductReactBySourceController@buildProductReactBySource',
    ]);

    Route::get('/cron/cron-build-ads-status', [
        'as' => 'product-react::cron-product-react',
        'uses' => 'ProductReactBuilderService@cronBuildAdsStatus',
    ]);

    Route::get('/find-product-low-rate-by-source', [
        'as' => 'product-react::find-product-low-rate-by-source',
        'uses' => 'Api\ApiProductReactBySourceService@findProductLowRate',
    ]);
});



Route::group(['prefix' => 'product-react/service', 'middleware' => config('app.system_auth_middleware')], function() {
    Route::get('/find',
    [
        'as' => 'product-react::find',
        'uses' => 'ProductReactService@find',
    ]);
    Route::get('/find-product-low-rate', [
            'as' => 'product-react::find-product-low-rate',
            'uses' => 'ProductReactService@findProductLowRate',
    ]);
    Route::get('/export',
    [
        'as' => 'product-react::exportToExcel',
        'uses' => 'ProductReactService@exportProductReact',
    ]);
    Route::get('/export-product-low-rate', [
            'as' => 'product-react::exportProductLowRate',
            'uses' => 'ProductReactService@exportProductLowRate',
    ]);
    Route::post('/config/global', [
        'as' => 'product-react::config::global',
        'uses' => 'ProductReactConfigService@configGlobal',
    ]);

    Route::post('/config/product', [
        'as' => 'product-react::config::product',
        'uses' => 'ProductReactConfigService@configProduct',
    ]);

    Route::post('/config/ads-status', [
        'as' => 'product-react::config::product',
        'uses' => 'ProductReactConfigService@configAdsStatus',
    ]);


    Route::get('/config/find', [
        'as' => 'product-react::config::find',
        'uses' => 'ProductReactConfigService@find',
    ]);
});

## END OF ROUTE GROUP FOR PRODUCT REACTION ##



## ROUTE GROUP FOR FUNCTION PRODUCT WARNING ##
Route::group(['prefix' => 'product-warning', 'middleware' => config('app.system_auth_middleware')], function() {
    Route::get('/index',[
        'as' => 'product-warning::home',
        'uses' => 'ProductWarningController@index'
    ]);

    Route::group(['prefix' => 'api'], function () {
        Route::post('/get-list-warning',['uses' => 'ProductWarningController@getListProductWarning']);
        Route::post('/update-crawl-status',['uses' => 'ProductWarningController@updateCrawlStatus']);
    });
});

## END OF ROUTE GROUP FOR PRODUCT WARNING ##




// Mudule internal request
Route::get('/module/ads/feed-products', [
    'as' => 'ads::getfeed::products',
    'uses' => 'ProductController@feed',
]);

Route::get('/module/ads/cancel-approval-product-by-category', [
    'as' => 'ads::product::cancel-approval-product-by-category',
    'uses' => 'ProductController@cancelApprovalProductByCategory',
]);
Route::get('/module/ads/limit-product-gmc', [
    'as' => 'ads::product::limit-product-gmc',
    'uses' => 'ProductController@limitProductGMC',
]);
Route::get('/module/ads/unapprove-product-gmc', [
    'as' => 'ads::product::unapprove-product-gmc',
    'uses' => 'ProductController@unapproveProductGMC',
]);
Route::get('/module/ads/merchant-product-state', [
    'as' => 'ads::product::get-merchant-product-state',
    'uses' => 'ProductController@getMerchantProductStates',
]);
Route::post('/module/ads/merchant-product-state', [
    'as' => 'ads::product::create-merchant-product-state',
    'uses' => 'ProductController@createMerchantProductState',
]);
Route::get('/module/ads/gmc-feed', [
    'as' => 'ads::product::gmc-feed',
    'uses' => 'ProductController@gmcFeed',
]);


// Module external request
Route::get('/shopping-feed/warning', [
    'as' => 'ads::shoppingfeed::warning',
    'uses' => 'AdsController@warningMissingProduct',
]);

Route::get('/shopping-feed/{idFeedSetting}', [
    'as' => 'ads::getfeed',
    'uses' => 'AdsController@getShoppingFeed',
]);
Route::get('/module/ads/email-marketing-feed', [
    'as' => 'ads::emailmarketing',
    'uses' => 'AdsController@emailMarketingFeed',
]);

Route::get('/page-feed/{idFeedSetting}', [
    'as' => 'ads::getfeed::pagefeed',
    'uses' => 'AdsController@getPageFeed',
]);

Route::get('/remarketing-feed/{idFeedSetting}', [
    'as' => 'ads::getfeed::remarketingfeed',
    'uses' => 'AdsController@getRemarketingFeed',
]);


Route::get('/feed/refreshFeeds', [
    'as' => 'ads::feed:refresh',
    'uses' => 'AdsController@refreshFeeds',
]);

Route::get('/module/ads/update-merchant-category', [
    'as' => 'ads::merchantcategory:update',
    'uses' => 'AdsController@initMerchatCategory',
]);

Route::get('/feeds/{type}/{fileName}', [
    'as' => 'ads::feeds:file',
    'uses' => 'AdsController@getFeedFile',
]);


Route::get('/module/ads/push-customer-list', [
    'as' => 'ads::customerlist:push',
    'uses' => 'Cron\AdsController@pushCustomerList',
]);
Route::get('/module/ads/conversion-adjustment', [
    'as' => 'ads::conversion:adjustment',
    'uses' => 'AdsController@adjustConversion',
]);
Route::get('/module/approved-vertising/update-ctr', [
    'as' => 'ads::approved-vertising:update-ctr',
    'uses' => 'Cron\AdsController@updateCtr',
]);
Route::get('/module/ads/save-product-warning', [
    'as' => 'ads::save-product-warning',
    'uses' => 'Cron\AdsController@saveProductWarning',
]);
Route::get('/module/ads/save-performance-view', [
    'as' => 'ads::ads:save-performance-view',
    'uses' => 'Cron\AdsController@savePerformanceGoogleAds',
]);
Route::get('/module/ads/save-keyword-to-seller', [
    'as' => 'ads::ads:save-keyword-seller',
    'uses' => 'Cron\AdsController@saveKeywordToSeller',
]);
Route::get('/module/ads/save-seller-offsite-ads', [
    'as' => 'ads::ads:save-seller-offsite-ads',
    'uses' => 'Cron\AdsController@buildSellerOffsiteAds',
]);
Route::get('/module/ads/build-label-vincustom', [
    'as' => 'ads::ads:build-label-vincustom',
    'uses' => 'Cron\AdsController@buildLabelVinCustom',
]);
Route::get('/module/ads/product-performance', [
    'as' => 'ads::ads:product-performance',
    'uses' => 'AdsProductPerformanceController@findLatest',
]);
Route::get('/module/ads/save-cost', [
    'as' => 'ads::ads:save-cost',
    'uses' => 'Cron\AdsController@storeCost',
]);
Route::get('/module/ads/tiktok/save-cost', [
    'as' => 'ads::ads:tiktok:save-cost',
    'uses' => 'Cron\AdsController@saveTiktokCost',
]);
Route::get('/module/ads/facebook/save-cost', [
    'as' => 'ads::ads:facebook:save-cost',
    'uses' => 'Cron\AdsController@saveFacebookCost',
]);
Route::get('/module/ads/merchant/fetch-now', [
    'as' => 'ads::ads:merchant::fetch-now',
    'uses' => 'MerchantProductContentController@fetchNow',
]);
Route::get('/module/ads/merchant/max-id', [
    'as' => 'ads::ads:merchant::max-id',
    'uses' => 'MerchantProductContentController@getProductMaxId',
]);
Route::get('/module/ads/merchant/insert', [
    'as' => 'ads::ads:merchant::insert',
    'uses' => 'MerchantProductContentController@cronUpdateProduct',
]);
Route::post('/module/ads/merchant/insert', [
    'as' => 'ads::ads:merchant::post::insert',
    'uses' => 'MerchantProductContentController@cronUpdateProduct',
]);
Route::post('/module/ads/merchant/update-expired', [
    'as' => 'ads::ads:merchant::post::update-expired',
    'uses' => 'MerchantProductContentController@updateExpiredProduct',
]);
Route::get('/module/ads/merchant/update-expired', [
    'as' => 'ads::ads:merchant::get::update-expired',
    'uses' => 'MerchantProductContentController@updateExpiredProduct',
]);
Route::get('/module/ads/merchant/insert-to-queue', [
    'as' => 'ads::ads:merchant::insertToQueue',
    'uses' => 'MerchantProductContentController@insertToQueue',
]);
Route::get('/module/ads/merchant/insert-priority', [
    'as' => 'ads::ads:merchant::insertPriority',
    'uses' => 'MerchantProductContentController@insertPriority',
]);
Route::get('/module/ads/merchant/insert-seller-priority', [
    'as' => 'ads::ads:merchant::insertSellerPriority',
    'uses' => 'MerchantProductContentController@insertSellerPriority',
]);
Route::get('/module/ads/merchant/update-price', [
    'as' => 'ads::ads:merchant::updatePrice',
    'uses' => 'MerchantProductContentController@cronUpdatePrice',
]);
Route::get('/module/ads/merchant/delete-by-score', [
    'as' => 'ads::ads:merchant::deleteByScore',
    'uses' => 'MerchantProductContentController@removeProductByScore',
]);
Route::post('/module/ads/merchant/update-merchant-data', [
    'as' => 'ads::ads:merchant::updateMerchantData',
    'uses' => 'MerchantProductContentController@updateMerchantData',
]);
Route::get('/module/ads/merchant/update-report', [
    'as' => 'ads::ads:merchant::updateReport',
    'uses' => 'MerchantProductContentController@updateReport',
]);
Route::get('/module/ads/merchant/build-report', [
    'as' => 'ads::ads:merchant::buildReport',
    'uses' => 'MerchantProductContentController@cronBuildReport',
]);
Route::get('/module/ads/merchant/calculate-insert', [
    'as' => 'ads::ads:merchant::calculateInsert',
    'uses' => 'MerchantProductContentController@preCalculateInsertProduct',
]);
Route::get('/module/ads/merchant/look-for-product-info-missing', [
    'as' => 'ads::ads:merchant::lookForProductInfoMissing',
    'uses' => 'MerchantProductContentController@lookForProductInfoMissing',
]);
Route::get('/module/ads/merchant/calculate-delete', [
    'as' => 'ads::ads:merchant::calculateDelete',
    'uses' => 'MerchantProductContentController@preCalculateDeleteProduct',
]);
Route::get('/module/ads/merchant/get-pending-product', [
    'as' => 'ads::ads:merchant::get-pending-product',
    'uses' => 'MerchantProductContentController@getProductNotApprove',
]);
Route::get('/module/ads/merchant/auto-check-violation', [
    'as' => 'ads::ads:merchant::auto-check-violation',
    'uses' => 'MerchantProductContentController@cronCheckViolation',
]);
Route::get('/module/ads/merchant/get-product-high-click-potential', [
    'as' => 'ads::ads:merchant::get-product-high-click-potential',
    'uses' => 'MerchantProductContentController@getProductHighClickPotential',
]);
Route::get('/module/ads/merchant/delete', [
    'as' => 'ads::ads:merchant::delete',
    'uses' => 'MerchantProductContentController@cronRemoveProduct',
]);
Route::post('/module/ads/merchant/hardDelete', [
    'as' => 'ads::ads:merchant::hardDelete',
    'uses' => 'MerchantProductContentController@hardDelete',
]);
Route::get('/module/ads/merchant/cache-shipping-info', [
    'as' => 'ads::ads:merchant::cacheShippingInfo',
    'uses' => 'MerchantProductContentController@cronCacheShippingInfo',
]);
Route::get('/module/ads/merchant/delete-temp', [
    'as' => 'ads::ads:merchant::delete-temp',
    'uses' => 'MerchantProductContentController@cronRemoveTempProduct',
]);
Route::get('/module/ads/merchant/expire', [
    'as' => 'ads::ads:merchant::expire',
    'uses' => 'MerchantProductContentController@getListExpired',
]);
Route::get('/module/ads/merchant/count-product-category', [
    'as' => 'ads::ads:merchant::count-product-category',
    'uses' => 'MerchantProductContentController@countProductByCategory',
]);

Route::get('/module/ads/update-product-disapproved', [
    'as' => 'ads::merchantcategory:update:disapproved',
    'uses' => 'AdsController@cronUpdateProductDisapproved',
]);
Route::group(['middleware' => config('app.system_auth_middleware')], function() {
    Route::get('/module/approved-vertising/find', [
        'as' => 'ads::find:approved-vertising',
        'uses' => 'ProductApproveAdvertisingService@find',
    ]);
    Route::get('/module/ads/export-customer', [
        'as' => 'ads::exprot:customer',
        'uses' => 'AdsController@exportCustomer',
    ]);
    Route::get('/module/ads/approve-advertising', [
        'as' => 'ads::approve:advertising',
        'uses' => 'ProductApproveAdvertisingService@index',
    ]);
    Route::post('/service/ads/approve-printerest', [
        'as' => 'ads::service:approve-printerest',
        'uses' => 'ProductApproveAdvertisingService@approvePrinterest',
    ]);
});

Route::get('/product-cost-ads/build', [
    'as' => 'product-cost-ads::build',
    'uses' => 'ProductCostAdsController@buildProductAdsCost',
]);

Route::group(['prefix' => 'device-report', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/', ['uses' => 'ProductReportController@index'])->name('device-report::home');
    Route::post('find', ['uses' => 'ProductReportController@find']);
    Route::get('export-excel', ['uses' => 'ProductReportController@export']);
});


Route::group(['prefix' => '/report', 'middleware' => config('app.system_auth_middleware')], function () {
    Route::get('/product-statistic', ['uses' => 'ProductReportController@statistic'])->name('product-statistic::home');
    Route::get('/product-statistic/find', ['uses' => 'ProductReportController@statisticData'])->name('product-statistic::find');
    Route::get('/product-statistic/export', ['uses' => 'ProductReportController@exportStatisticData'])->name('product-statistic::find');
});

Route::group(['prefix' => '/report'], function () {
    Route::get('/product-statistic/build', ['uses' => 'ProductReportController@buildProductReport'])->name('product-statistic::buildProductReport');
});

Route::get('/module/ads/search-ad/create', [
    'as' => 'ads::ads:search-ad::create',
    'uses' => 'SearchAdController@createAd',
]);

Route::get('/module/ads/feed/page-feed', [
    'as' => 'ads::ads:feed::page-feed',
    'uses' => 'FeedController@cronCreatePageFeed',
]);
Route::get('/module/ads/feed/page-feed/delete', [
    'as' => 'ads::ads:feed::page-feed/delete',
    'uses' => 'FeedController@cronRemovePageFeed',
]);
Route::get('/module/ads/bing/feed', [
    'as' => 'ads::ads:bing::feed',
    'uses' => 'BingController@cronUpdateFeed',
]);
Route::get('/module/ads/bing/feed/clean', [
    'as' => 'ads::ads:bing::feed::clean',
    'uses' => 'BingController@cleanFeed',
]);
Route::get('/module/ads/bing/feed/remove', [
    'as' => 'ads::ads:bing::feed::remove',
    'uses' => 'BingController@cronRemoveProduct',
]);
Route::get('/module/ads/bing/feed/ftp', [
    'as' => 'ads::ads:bing::feed::ftp',
    'uses' => 'BingController@ftpUpload',
]);
Route::get('/module/ads/bing/insert', [
    'as' => 'ads::ads:bing::insert',
    'uses' => 'BingController@insert',
]);
Route::get('/module/ads/bing/delete', [
    'as' => 'ads::ads:bing::delete',
    'uses' => 'BingController@delete',
]);
Route::get('/module/ads/bing/push-to-queue', [
    'as' => 'ads::ads:bing::pushToQueue',
    'uses' => 'BingController@pushToQueue',
]);
Route::post('/module/ads/bing/update-merchant-data', [
    'as' => 'ads::ads:bing::updateMerchantData',
    'uses' => 'BingController@updateMerchantData',
]);
Route::get('/module/ads/cj/feed', [
    'as' => 'ads::ads:cj::feed',
    'uses' => 'CjController@cronUpdateFeed',
]);
Route::get('/module/ads/pinterest/feed', [
    'as' => 'ads::ads:pinterest::feed',
    'uses' => 'PinterestController@cronUpdateFeed',
]);
Route::get('/module/ads/pinterest/feed/remove', [
    'as' => 'ads::ads:pinterest::feed::remove',
    'uses' => 'PinterestController@cronRemoveProduct',
]);
Route::get('/module/ads/pinterest/feed/clean', [
    'as' => 'ads::ads:pinterest::feed::clean',
    'uses' => 'PinterestController@cleanFeed',
]);

Route::get('/module/ads/awin/feed', [
    'as' => 'ads::ads:awin::feed',
    'uses' => 'AwinController@cronUpdateFeed',
]);
Route::get('/module/ads/awin/feed/remove', [
    'as' => 'ads::ads:awin::feed::remove',
    'uses' => 'AwinController@cronRemoveProduct',
]);
Route::get('/module/ads/awin/feed/clean', [
    'as' => 'ads::ads:awin::feed::clean',
    'uses' => 'AwinController@cleanFeed',
]);
Route::get('/module/ads/tiktok/feed', [
    'as' => 'ads::ads:tiktok::feed',
    'uses' => 'TiktokController@cronUpdateFeed',
]);
Route::get('/module/ads/tiktok/feed/remove', [
    'as' => 'ads::ads:tiktok::feed::remove',
    'uses' => 'TiktokController@cronRemoveProduct',
]);
Route::get('/module/ads/bounce-commerce/feed', [
    'as' => 'ads::ads:bounce-commerce::feed',
    'uses' => 'BounceCommerceController@cronUpdateFeed',
]);
Route::get('/module/ads/bounce-commerce/feed/remove', [
    'as' => 'ads::ads:bounce-commerce::feed::remove',
    'uses' => 'BounceCommerceController@cronRemoveProduct',
]);
Route::get('/module/ads/customer/feed', [
    'as' => 'ads::ads:customer::feed',
    'uses' => 'MerchantProductContentController@exportCustomer',
]);
Route::get('/module/ads/upload/gcs', [
    'as' => 'ads::ads:upload::gcs',
    'uses' => 'AdsController@uploadFileToGoogleCloudStorage',
]);
Route::get('/module/ads/snapchat/feed', [
    'as' => 'ads::ads:snapchat::feed',
    'uses' => 'SnapchatController@cronUpdateFeed',
]);
Route::get('/module/ads/snapchat/feed/remove', [
    'as' => 'ads::ads:snapchat::feed::remove',
    'uses' => 'SnapchatController@cronRemoveProduct',
]);
Route::get('/module/ads/twitter/feed', [
    'as' => 'ads::ads:twitter::feed',
    'uses' => 'TwitterController@cronUpdateFeed',
]);
Route::get('/module/ads/reddit/feed', [
    'as' => 'ads::ads:reddit::feed',
    'uses' => 'RedditController@cronUpdateFeed',
]);
Route::get('/module/ads/merchant/insert-variant', [
    'as' => 'ads::ads:merchant::insert::variant',
    'uses' => 'MerchantProductContentController@cronInsertProductVariant',
]);
Route::get('/module/ads/merchant/feed', [
    'as' => 'ads::ads:merchant::feed',
    'uses' => 'MerchantProductContentController@createTextFile',
]);
Route::get('/module/ads/pagefeed/feed', [
    'as' => 'ads::ads:pagefeed::feed',
    'uses' => 'PageFeedController@cronUpdateFeed',
]);
Route::get('/module/ads/pagefeed/feed/remove', [
    'as' => 'ads::ads:pagefeed::feed::remove',
    'uses' => 'PageFeedController@cronRemoveProduct',
]);
Route::get('/module/ads/build-review-feed', [
    'as' => 'ads::ads:build-review-feed',
    'uses' => 'ReviewController@buildReviewFeed',
]);

Route::group(['prefix' => '/module/ads/pedding-products', 'middleware' => config('app.system_auth_middleware')], function () {

    Route::get('/', [
        'as' => 'ads::pending::product',
        'uses' => 'PendingProductController@list'
    ]);

    Route::get('/get-products', [
        'as' => 'ads::pending::get-products',
        'uses' => 'PendingProductController@getProducts'
    ]);
    
    Route::get('/get-staff-product-count', [
        'as' => 'ads::pending::staff-product-count',
        'uses' => 'PendingProductController@getProductCountByStaff'
    ]);

});

Route::group(['prefix' => '/module/ads/api', 'middleware' => ['auth_api'], 'namespace' => 'Api'], function () {

    Route::get('/pedding-products/get-products', [
        'uses' => 'PendingProductController@getProducts'
    ]);

    Route::get('/products/google-ads-issues', [
        'uses' => 'PendingProductController@getGoogleAdsIssues'
    ]);

});
Route::group(['prefix' => '/module/ads/data-export'], function () {
    Route::post('/export-email-csv', [
        'as' => 'ads::export::email-csv',
        'uses' => 'DataExportController@exportCustomerEmail'
    ]);
    Route::post('/cron-export-email-csv', [
        'as' => 'ads::export::cron-email-csv',
        'uses' => 'DataExportController@cronExportCustomerEmail'
    ]);
    Route::get('/social-platform-export-csv', [
        'as' => 'ads::export::social-platform',
        'uses' => 'DataExportController@createFileCsvBySocialPlatform'
    ]);
});

Route::any('/module/ads/product-ads/build-product', [
    'as' => 'ads::ads:product-ads::build-product',
    'uses' => 'ProductAdsController@buildProductAds',
]);
Route::any('/module/ads/product-ads/update-status', [
    'as' => 'ads::ads:product-ads::update-status',
    'uses' => 'ProductAdsController@updateStatus',
]);
Route::any('/module/ads/product-ads/update-sold', [
    'as' => 'ads::ads:product-ads::update-sold',
    'uses' => 'ProductAdsController@updateSold',
]);
Route::get('/module/ads/product-ads/max-id', [
    'as' => 'ads::ads:product-ads::max-id',
    'uses' => 'ProductAdsController@getMaxId',
]);
Route::get('/module/ads/product-ads/max-table-id', [
    'as' => 'ads::ads:product-ads::max-table-id',
    'uses' => 'ProductAdsController@getMaxTableId',
]);
Route::any('/module/ads/gmc/insert', [
    'as' => 'ads::ads:gmc::insert',
    'uses' => 'GoogleMerchantController@insert',
]);
Route::any('/module/ads/gmc/delete', [
    'as' => 'ads::ads:gmc::delete',
    'uses' => 'GoogleMerchantController@delete',
]);
Route::any('/module/ads/mmc/insert', [
    'as' => 'ads::ads:mmc::insert',
    'uses' => 'MicrosoftMerchantController@insert',
]);

Route::group(['prefix' => '/module/ads/facebook'], function () {
    Route::post('/cron-build-product', [
        'as' => 'ads::facebook-feeds::cron-build-product',
        'uses' => 'FacebookController@cronBuildProductAds'
    ]);
    Route::post('/cron-update-product', [
        'as' => 'ads::facebook-feeds::cron-update-product',
        'uses' => 'FacebookController@cronUpdateProductAds'
    ]);
    Route::post('/cron-merge-product', [
        'as' => 'ads::facebook-feeds::cron-merge-product',
        'uses' => 'FacebookController@cronMergeByStorage'
    ]);
    Route::post('/cron-group-files', [
        'as' => 'ads::facebook-feeds::cron-group-files',
        'uses' => 'FacebookController@cronGroupFilesByIdRange'
    ]);
    Route::post('/group-files', [
        'as' => 'ads::facebook-feeds::group-files',
        'uses' => 'FacebookController@groupFilesOptimized'
    ]);
    Route::post('/build-product', [
        'as' => 'ads::facebook-feeds::build-product',
        'uses' => 'FacebookController@buildProductAds'
    ]);
    Route::post('/update-product', [
        'as' => 'ads::facebook-feeds::update-product',
        'uses' => 'FacebookController@updateProductAds'
    ]);
    Route::post('/merge-product', [
        'as' => 'ads::facebook-feeds::merge-product',
        'uses' => 'FacebookController@mergeDataSourceFiles'
    ]);
});

Route::group(['prefix' => '/module/ads/criteo'], function () {
    Route::post('/cron-build-product', [
        'as' => 'ads::criteo-feeds::cron-build-product',
        'uses' => 'CriteoController@cronBuildProductAds'
    ]);
    Route::post('/cron-update-product', [
        'as' => 'ads::criteo-feeds::cron-update-product',
        'uses' => 'CriteoController@cronUpdateProductAds'
    ]);
    Route::post('/cron-merge-product', [
        'as' => 'ads::criteo-feeds::cron-merge-product',
        'uses' => 'CriteoController@cronMergeByStorage'
    ]);
    Route::post('/cron-group-files', [
        'as' => 'ads::criteo-feeds::cron-group-files',
        'uses' => 'CriteoController@cronGroupFilesByIdRange'
    ]);
    Route::post('/group-files', [
        'as' => 'ads::criteo-feeds::group-files',
        'uses' => 'CriteoController@groupFilesOptimized'
    ]);
    Route::post('/build-product', [
        'as' => 'ads::criteo-feeds::build-product',
        'uses' => 'CriteoController@buildProductAds'
    ]);
    Route::post('/update-product', [
        'as' => 'ads::criteo-feeds::update-product',
        'uses' => 'CriteoController@updateProductAds'
    ]);
    Route::post('/merge-product', [
        'as' => 'ads::criteo-feeds::merge-product',
        'uses' => 'CriteoController@mergeDataSourceFiles'
    ]);
});

