<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\Campaign;
use DB;

class CampaignService extends Service {
    const MODEL = Campaign::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return Campaign::findOrFail($filter['id']);
        }
        $query = Campaign::query();
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_campaigns.*'));
        }
        
        return $this->executeQuery($query, $filter);
        
    }

    public function campaignByIds() {
        $items = Campaign::all();
        $retVal = [];
        foreach ($items as $item) {
            $retVal[$item->campaign_id] = $item;
        }
        return $retVal;
    }
    
}