<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\Click;
use DB;

class ClickService extends Service {
    const MODEL = Click::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return Click::findOrFail($filter['id']);
        }
        $query = Click::query();
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_click.*'));
        }

        return $this->executeQuery($query, $filter);
        
    }

    public function getClickProductToAdvertise($filter, $type = null) {
        if (isset($filter['codes']) && empty($filter['codes'])) {
            $filter['codes'] = [-1];
        }
        if (isset($filter['productIds']) && empty($filter['productIds'])) {
            $filter['productIds'] =[-1];
        }
        $query = \DB::table('click')
                        ->where('source', '=', 'adwords');
        if (isset($filter['fromDate'])) {
            $query->where('date', '>=', $filter['fromDate']);
        }
        if (isset($filter['toDate'])) {
            $query->where('date', '<=', $filter['toDate']);
        }
        if (isset($filter['campaign_id']) && $filter['campaign_id'] != '') {
            $query->where('campaign_id', '=', $filter['campaign_id']);
        }
        if (isset($filter['campaign_type']) && $filter['campaign_type'] != '') {
            $query->where('campaign_type', '=', $filter['campaign_type']);
        }

        if (isset($filter['codes']) && !empty($filter['codes'])) {
            $query->whereIn('sku', $filter['codes']);
            if ($type == 'campaign_type') {
                $query->groupBy('sku', 'campaign_type')
                    ->select("sku", "campaign_type", \DB::raw("sum(clicks) as click"));
            } else if($type == 'campaign_id') {
                $query->groupBy('sku', 'campaign_id')
                        ->select("sku", "campaign_id", \DB::raw("sum(clicks) as click"));
            } else {
                $query->groupBy('sku')
                        ->select('sku', \DB::raw("sum(clicks) as click"));
            }
        }
        if (isset($filter['productIds']) && !empty($filter['productIds'])) {
            $query->whereIn('product_id', $filter['productIds']);
            if ($type == 'campaign_type') {
                $query->groupBy('product_id', 'campaign_type')
                    ->select("product_id", "campaign_type", \DB::raw("sum(clicks) as click"));
            } else if($type == 'campaign_id') {
                $query->groupBy('product_id', 'campaign_id')
                        ->select("product_id", "campaign_id", \DB::raw("sum(clicks) as click"));
            } else {
                $query->groupBy('product_id')
                        ->select('product_id', \DB::raw("sum(clicks) as click"));
            }
        }
        
        if (isset($filter['metric']) && $filter['metric'] == 'count') {
           $count = \DB::table(\DB::raw("(" . $query->toSql() . ") AS x"))
                ->mergeBindings($query)
                ->count();
            return $count;
        } else {
            if (isset($filter['orders']) && count($filter['orders']) > 0) {
                foreach ($filter['orders'] as $key => $value) {
                    $query->orderBy($key, $value);
                }
            }
            if (isset($filter['pageSize']) && isset($filter['pageId'])) {
                $query->forPage($filter['pageId'] + 1, $filter['pageSize']);
            }
            return $query->get();
        }
    }
    
}