<?php

namespace Modules\Ads\Services;


class EmailService extends Service
{

    public function sendWarningEmail($data, $subject, $to = 'phamanhtuan206@gmail.com')
    {
        $token = $this->getRefreshToken();
        $result = null;
        if ($token && $data) {
            $emailService = config('ads::email.email_service_url');
            $emailData['to'] = $to;
            $emailData['name'] = $subject;
            $emailData['subject'] = $subject;
            $emailData['content'] = json_encode($data);
            $emailData['token'] = $token;
            $result = self::sendRequest($emailService . '/api/send-mail', "POST", $emailData);
        }
        return $result;
    }

    protected function getRefreshToken()
    {

        $emailService = config('ads::email.email_service_url');
        $options = array(
            'email' => config('ads::email.email_service_user'),
            'password' => config('ads::email.email_service_password')
        );
        $result = self::sendRequest($emailService . '/auth/login', "POST", $options);
        if (isset($result->token)) {
            return $result->token;
        }
        return null;
    }

    protected static function sendRequest($url, $method = "GET", $data = [], $validate = true) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        curl_setopt($channel, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $response = curl_exec($channel);
        curl_close($channel);
        $responseInJson = json_decode($response);
        return isset($responseInJson->result) ? $responseInJson->result : $responseInJson;
    }


}