<?php
namespace Modules\Ads\Services;

use Google\AdsApi\AdWords\AdWordsServices;
use Google\AdsApi\AdWords\AdWordsSession;
use Google\AdsApi\AdWords\AdWordsSessionBuilder;
use Google\AdsApi\AdWords\Reporting\v201809\DownloadFormat;
use Google\AdsApi\AdWords\Reporting\v201809\ReportDefinition;
use Google\AdsApi\AdWords\Reporting\v201809\ReportDefinitionDateRangeType;
use Google\AdsApi\AdWords\Reporting\v201809\ReportDownloader;
use Google\AdsApi\AdWords\ReportSettingsBuilder;
use Google\AdsApi\AdWords\v201809\cm\AdGroup;
use Google\AdsApi\AdWords\v201809\cm\AdGroupCriterionOperation;
use Google\AdsApi\AdWords\v201809\cm\AdGroupCriterionService;
use Google\AdsApi\AdWords\v201809\cm\AdGroupOperation;
use Google\AdsApi\AdWords\v201809\cm\AdGroupService;
use Google\AdsApi\AdWords\v201809\cm\BiddableAdGroupCriterion;
use Google\AdsApi\AdWords\v201809\cm\BiddingStrategyConfiguration;
use Google\AdsApi\AdWords\v201809\cm\CampaignCriterion;
use Google\AdsApi\AdWords\v201809\cm\CampaignCriterionOperation;
use Google\AdsApi\AdWords\v201809\cm\CampaignCriterionService;
use Google\AdsApi\AdWords\v201809\cm\CampaignService;
use Google\AdsApi\AdWords\v201809\cm\CpcBid;
use Google\AdsApi\AdWords\v201809\cm\Criterion;
use Google\AdsApi\AdWords\v201809\cm\DateRange;
use Google\AdsApi\AdWords\v201809\cm\IpBlock;
use Google\AdsApi\AdWords\v201809\cm\Money;
use Google\AdsApi\AdWords\v201809\cm\NegativeCampaignCriterion;
use Google\AdsApi\AdWords\v201809\cm\Operator;
use Google\AdsApi\AdWords\v201809\cm\OrderBy;
use Google\AdsApi\AdWords\v201809\cm\Paging;
use Google\AdsApi\AdWords\v201809\cm\Platform;
use Google\AdsApi\AdWords\v201809\cm\ReportDefinitionReportType;
use Google\AdsApi\AdWords\v201809\cm\Selector;
use Google\AdsApi\AdWords\v201809\cm\SortOrder;
use Google\AdsApi\AdWords\v201809\cm\AdGroupExtensionSetting;
use Google\AdsApi\AdWords\v201809\cm\AdGroupExtensionSettingOperation;
use Google\AdsApi\AdWords\v201809\cm\AdGroupExtensionSettingService;
use Google\AdsApi\AdWords\v201809\cm\CallFeedItem;
use Google\AdsApi\AdWords\v201809\cm\DayOfWeek;
use Google\AdsApi\AdWords\v201809\cm\ExtensionSetting;
use Google\AdsApi\AdWords\v201809\cm\ExtensionSettingPlatform;
use Google\AdsApi\AdWords\v201809\cm\FeedItemSchedule;
use Google\AdsApi\AdWords\v201809\cm\FeedType;
use Google\AdsApi\AdWords\v201809\cm\MinuteOfHour;
use Google\AdsApi\AdWords\v201809\cm\Operator as Operator2;
use Google\AdsApi\AdWords\v201809\cm\Predicate;
use Google\AdsApi\AdWords\v201809\cm\PredicateOperator;
use Google\AdsApi\Common\OAuth2TokenBuilder;

class GoogleAdsService extends Service {

    protected $campaignReportField = [
        'CampaignId',
        'CampaignName',
        'CampaignStatus',
        'AdvertisingChannelType',
    ];

    public function getCampaignReportField() {
        return $this->campaignReportField;
    }

    public function buildSessionAccount($clientCustomerId) {
        
        $fromFile = \Config::get('ads::ads.file_path');
        if(!file_exists($fromFile)) {
            throw new \Exception('The module Product Advertising require a file "adsapi_php.ini" in /config directory');
        }
        // User log
        try {
            $oAuth2Credential = (new OAuth2TokenBuilder())
                ->fromFile($fromFile)
                ->build();
            $session = (new AdWordsSessionBuilder())
                ->fromFile($fromFile)
                ->withClientCustomerId($clientCustomerId)
                ->withOAuth2Credential($oAuth2Credential)
                ->build();
            return $session;
         } catch (Exception $e) {
             printf("An error has occurred: %s\n", $e->getMessage());
         }
    }

    public function downloadReport($filters) {
        $filePath = storage_path() . '/' . $filters['fileName'] . '_' . $filters['accountKey'] . '.csv';
        if (!file_exists($filePath)) {
            $fp = fopen($filePath, 'w');
            fclose($fp);
        }
        $selector = new Selector();
        $selector->setFields($filters['fields']);
        if ($filters['timeType'] == 'CUSTOM_DATE') {
            $selector->setDateRange(new DateRange($filters['fromDate'], $filters['toDate']));
        }
        if (array_key_exists('predicates', $filters)) {
            $selector->setPredicates($filters['predicates']);
        }
        $reportDefinition = new ReportDefinition();
        $reportDefinition->setSelector($selector);
        $reportDefinition->setReportName(
            'Report #' . uniqid());
        $timeType = $this->getTimeType($filters['timeType']);
        $reportDefinition->setDateRangeType($timeType);
        $reportType = $this->getReportType($filters['reportType']);
        $reportDefinition->setReportType($reportType);
        $reportDefinition->setDownloadFormat(DownloadFormat::CSV);
        $reportDownloader = new ReportDownloader($filters['session']);
        $reportSettingsOverride = (new ReportSettingsBuilder())
            ->includeZeroImpressions(false)
            ->build();
        $reportDownloadResult = $reportDownloader->downloadReport(
        $reportDefinition, $reportSettingsOverride);
        $reportDownloadResult->saveToFile($filePath);
    }

    public function readReport($filters) {
        $filePath =  storage_path() . '/' . $filters['fileName'] . '_' . $filters['accountKey'] . '.csv';
        $data = $this->readFile($filePath);
        $report = [];
        foreach ($data as $key => $ad) {
            if ($key != 0 && $key != 1) {
                $std = new stdClass();
                $std->campaignId = $ad[0];
                $std->campaignName = $ad[1];
                $std->adGroupId = $ad[2];
                $std->adGroupName = $ad[3];
                $std->keyword = $ad[4];
                $std->qualityScore = $ad[5];
                $report[] = $std;
            }
        }
        return $report;
    }

    private function getTimeType($type) {
        $retVal = ReportDefinitionDateRangeType::TODAY;
        if ($type == 'YESTERDAY') {
            $retVal = ReportDefinitionDateRangeType::YESTERDAY;
        }
        if ($type == 'LAST_7_DAYS') {
            $retVal = ReportDefinitionDateRangeType::LAST_7_DAYS;
        }
        if ($type == 'LAST_30_DAYS') {
            $retVal = ReportDefinitionDateRangeType::LAST_30_DAYS;
        }
        if ($type == 'CUSTOM_DATE') {
            $retVal = ReportDefinitionDateRangeType::CUSTOM_DATE;
        }
        if ($type == 'ALL_TIME') {
            $retVal = ReportDefinitionDateRangeType::ALL_TIME;
        }
        return $retVal;
    }

    private function getReportType($type) {
        $retVal = '';
        if ($type == 'keyword') {
            $retVal = ReportDefinitionReportType::KEYWORDS_PERFORMANCE_REPORT;
        }
        if ($type == 'adgroup') {
            $retVal = ReportDefinitionReportType::ADGROUP_PERFORMANCE_REPORT;
        }
        if ($type == 'campaign') {
            $retVal = ReportDefinitionReportType::CAMPAIGN_PERFORMANCE_REPORT;
        }
        if ($type == 'criteria') {
            $retVal = ReportDefinitionReportType::CRITERIA_PERFORMANCE_REPORT;
        }
        return $retVal;
    }

    public function readReportCampaign($filters) {
        $filePath = storage_path() . '/' . $filters['fileName'] . '_' . $filters['accountKey'] . '.csv';
        $data = $this->readFile($filePath);
        $report = [];
        foreach ($data as $key => $ad) {
            if ($key != 0 && $key != 1 && $ad[0] != 'Total') {
                $std = new \stdClass();
                $std->campaignId = $ad[0];
                $std->campaignName = $ad[1];
                $std->status = $ad[2];
                $std->campaignType = $ad[3];
                $report[] = $std;
            }
        }
        return $report;
    }

    public function getCampaigns($session) {
        $adWordsServices = new AdWordsServices();
        $campaignService = $adWordsServices->get($session, CampaignService::class);
        // Create selector.
        $selector = new Selector();
        $selector->setFields(['Id', 'Name', 'Status']);
        $selector->setOrdering([new OrderBy('Name', SortOrder::ASCENDING)]);
        $selector->setPaging(new Paging(0, 500));
        $totalNumEntries = 0;
        $retVal = [];
        do {
            // Make the get request.
            $page = $campaignService->get($selector);
            // Display results.
            if ($page->getEntries() !== null) {
                $totalNumEntries = $page->getTotalNumEntries();
                foreach ($page->getEntries() as $campaign) {
                   $retVal[] = ['id' => $campaign->getId(), 'status' => $campaign->getStatus()];
                }
            }
            // Advance the paging index.
            $selector->getPaging()->setStartIndex(
                $selector->getPaging()->getStartIndex() + 500
            );
        } while ($selector->getPaging()->getStartIndex() < $totalNumEntries);
        return $retVal;
    }

    public function getAdgroups($session, $campaignIds) {
        $adWordsServices = new AdWordsServices();
        $adGroupService = $adWordsServices->get($session, AdGroupService::class);
        $selector = new Selector();
        $selector->setFields(['Id', 'Name', 'Status', 'AdGroupType', 'CampaignId', 'CampaignName', 'CampaignStatus']);
        $selector->setOrdering([new OrderBy('Name', SortOrder::ASCENDING)]);
        $selector->setPredicates(
            [new Predicate('CampaignId', PredicateOperator::IN, $campaignIds)]
        );
        $selector->setPaging(new Paging(0, 500));
        $totalNumEntries = 0;
        $retVal = [];
        do {
            $page = $adGroupService->get($selector);
            if ($page->getEntries() !== null) {
                $totalNumEntries = $page->getTotalNumEntries();
                foreach ($page->getEntries() as $adGroup) {
                    $item = [];
                    $item['id'] = $adGroup->getId();
                    $item['name'] = $adGroup->getName();
                    $item['status'] = $adGroup->getStatus();
                    $item['type'] = $adGroup->getAdGroupType();
                    $item['campaign_id'] = $adGroup->getCampaignId();
                    $item['campaign_name'] = $adGroup->getCampaignName();
                    $retVal[] = $item;
                }
            }
            $selector->getPaging()->setStartIndex(
                $selector->getPaging()->getStartIndex() + 500
            );
        } while ($selector->getPaging()->getStartIndex() < $totalNumEntries);
        return $retVal;
    }
}