<?php

namespace Modules\Ads\Services;


use Modules\Ads\Models\Product;
use DB;

class PendingProductService extends Service
{
    const MODEL = Product::class;

    public function getProducts($request)
    {
        $staffId = $request->input('staffId', null);
        $filter = $this->buildFilter($request->all());
        $query = DB::table('ads_pending_product')
            ->select('ads_pending_product.*', 'users.name as user_name')
            ->where('ads_pending_product.product_id', '>', 0)
            ->join('product_n_user', 'product_n_user.product_id', 'ads_pending_product.product_id')
            ->join('users', 'product_n_user.user_id', 'users.id');
        if (!empty($filter['fromDate'])) {
            $query->where('ads_pending_product.created_at', '>=', date('Y-m-d 00:00:00', strtotime($filter['fromDate'])));
        }
        if (!empty($filter['toDate'])) {
            $query->where('ads_pending_product.created_at', '<=', date('Y-m-d 23:59:59', strtotime($filter['toDate'])));
        }
        if (!empty($filter['reason'])) {
            $query->where('ads_pending_product.note', 'like', '%' .  $filter['reason'] . '%');
        }

        if (!empty($filter['product_name'])) {
            $query->where('ads_pending_product.title', 'like', '%' .  $filter['product_name'] . '%');
        }

        if (empty($staffId)) {
            $staffId = $this->getUserIdBySellerInfo($filter);
        }

        if ($staffId) {
            $query->where('product_n_user.user_id', $staffId);
        }

        $products = $query->paginate(100);

        return $products;
    }

    protected function buildFilter($filters)
    {
        $retVal = [];
        foreach ($filters as $key => $value) {
            $retVal[$key] = $value;
        }
        return $retVal;
    }

    protected function getUserIdBySellerInfo($filter)
    {
        $userId = '';
        if (!empty($filter['seller_token'])) {
            $user = DB::table('users')
                ->where('seller_token', $filter['seller_token'])
                ->where('status', 'ACTIVE')
                ->where('role', 'SELLER')
                ->first();
            if (!empty($user)) {
                $userId = $user->id;
            }
        }
        return $userId;
    }

    public function getGoogleAdsIssues($filter)
    {
        $userId = $this->getUserIdBySellerInfo($filter);
        $products = [];
        if (isset($userId)) {
            $query = \DB::table('product as p')
                            ->join('product_n_user as pnu', 'pnu.product_id', '=', 'p.id')
                            ->join('product_meta as pm', 'pm.product_id', '=', 'p.id')
                            ->where('pnu.user_id', $userId)
                            ->where('p.is_violation', 1)
                            ->where('pm.key', 'violation_errors');
            
            if (!empty($filter['product_name'])) {
                $query->where('p.name', 'like', '%' .  $filter['product_name'] . '%');
            }

            $products = $query->orderBy('created_at', 'DESC')->get(['p.name', 'p.sku', 'pm.value', 'pm.created_at']);
            $errors = config('ads::google_ads_errors');
            if (!empty($products) && !empty($errors)) {
                foreach ($products as $item) {
                    if (!empty($item->value)) {
                        $item->value = json_decode($item->value, 1);
                        foreach ($item->value as $key => $error) {
                            if (isset($errors[$error])) {
                                $item->value[$key] = $errors[$error];
                            }
                        }
                    }
                }
            }
        }

        return $products;
    }
}
