<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductAdvertising;
use DB;

class ProductAdvertisingService extends Service {
    const MODEL = ProductAdvertising::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return ProductAdvertising::findOrFail($filter['id']);
        }
        $query = ProductAdvertising::query();
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }
        if (array_key_exists('from', $filter)) {
            $query->where('date', '>=', $filter['from']);
        }
        if (array_key_exists('to', $filter)) {
            $query->where('date', '<=', $filter['to']);
        }   
        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_advertising.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }
    
}