<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductApproveAdvertising;
use DB;

class ProductApproveAdvertisingService extends Service {
    const MODEL = ProductApproveAdvertising::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return ProductApproveAdvertising::findOrFail($filter['id']);
        }
        $query = ProductApproveAdvertising::query();
        if (array_key_exists('skus', $filter) && !empty($filter['skus'])) {
            $query->whereIn('code', $filter['skus']);
        }
        if (array_key_exists('advertising_status', $filter)) {
            $query->where('advertising_status', '=', $filter['advertising_status']);
        }
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_approve_advertising.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }
    
}