<?php

namespace Modules\Ads\Services;

use Illuminate\Support\Facades\DB;

class ProductInfoGalleryService {
    private static $cacheGallery = [];
    private static $cacheTemplate = [];

    public static function getTemplateId($skuId) {
        if (!isset(self::$cacheTemplate[$skuId])) {
            $result = DB::table('product_template_sku')
                ->where('id', $skuId)
                ->first();

            self::$cacheTemplate[$skuId] = $result ? $result->template_id : 0; 
        }

        return self::$cacheTemplate[$skuId];
    }

    public static function getGallery($templateId) {
        if (!isset(self::$cacheGallery[$templateId])) {
            $result = DB::table('product_template_sku')
                ->where('template_id', $templateId)
                ->where('image_url', '!=', '')
                ->orderBy('id', 'asc')
                ->get();

            $gallery = $result->pluck('image_url')->toArray();
            self::$cacheGallery[$templateId] = $gallery;
        }
        return self::$cacheGallery[$templateId];
    }

    public static function getGalleryColorAndCode($gallery) {
        $result = [];
        foreach ($gallery as $imageUrl) {
            $info = self::getImageUrlInfo($imageUrl);
            if (!empty($info)) {
                if (!isset($result[$info['template']])) {
                    $result[$info['template']] = [];
                }
                $result[$info['template']][$info['color']] = $info['code'];
            }
        }

        return $result;
    }

    public static function getImageUrlInfo($imageUrl) {
        preg_match('/image\/([a-z0-9-]+),([a-z0-9-]+),([^,]+),([a-z0-9]+)\./', $imageUrl, $matches);
        if (count($matches) == 5) {
            $template = preg_replace("/-(\d+)$/", '', $matches[1]);

            return [
                'template' => $template,
                'originTemplate' => $matches[1],
                'color' => $matches[2],
                'code' => $matches[4],
            ];
        }
        return [];
    }

    public static function appendMoreGallery($skuId, $gallery, $limit = 8) {
        $templateId = self::getTemplateId($skuId);
        if ($templateId == 0) {
            return $gallery;
        }
        $baseImageUrl = $gallery[0];
        $baseImageUrlInfo = self::getImageUrlInfo($baseImageUrl);
        if (!count($baseImageUrlInfo)) {
            return $gallery;
        }
        $templateGallery = self::getGallery($templateId);
        $galleryColorAndCode = self::getGalleryColorAndCode($templateGallery);
        $existedColorCodes = [];
        foreach ($gallery as $imageUrl) {
            $info = self::getImageUrlInfo($imageUrl);
            if (!empty($info)) {
                $key = $info['template'] . ',' . $info['color'];
                $existedColorCodes[$key] = true;
            }
        }
        if (!isset($galleryColorAndCode[$baseImageUrlInfo['template']])) {
            return $gallery;
        }

        foreach ($galleryColorAndCode[$baseImageUrlInfo['template']] as $color => $colorCode) {
            if (!$limit) {
                break;
            }
            $key = $baseImageUrlInfo['template'] . ',' . $color;
            if (!isset($existedColorCodes[$key])) {
                $newImageUrl = str_replace("/" . $baseImageUrlInfo['originTemplate'], "/" . $baseImageUrlInfo['template'], $baseImageUrl);
                $newImageUrl = str_replace("," . $baseImageUrlInfo['color'] . ",", "," . $color . ",", $newImageUrl);
                $newImageUrl = str_replace("," . $baseImageUrlInfo['code'] . '.', ','. $colorCode . '.', $newImageUrl);
                $gallery[] = $newImageUrl;
                $limit--;
            }
        }

        return $gallery;
    }
}