<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductInfo;
use \Illuminate\Support\Facades\DB;

class ProductInfoService extends Service {
    const MODEL = ProductInfo::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return ProductInfo::findOrFail($filter['id']);
        }
        $query = ProductInfo::query();
        if (array_key_exists('skus', $filter) && !empty($filter['skus'])) {
            $query->whereIn('sku', $filter['skus']);
        }
        if (array_key_exists('product_ids', $filter) && !empty($filter['product_ids'])) {
            $query->whereIn('product_id', $filter['product_ids']);
        }
        if (array_key_exists('!skus', $filter) && !empty($filter['!skus'])) {
            $query->whereNotIn('sku', $filter['!skus']);
        }
        if (array_key_exists('!product_ids', $filter) && !empty($filter['!product_ids'])) {
            $query->whereNotIn('product_id', $filter['!product_ids']);
        }
        if (array_key_exists('is_variant', $filter) && $filter['is_variant']) {
            $query->where('is_variant', '=', 1);
        } else if (array_key_exists('is_variant', $filter) && !$filter['is_variant']) {
            $query->where('is_variant', '=', 0);
        }
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_info.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }

    public function getProductInfoBySkus() {
        $items = ProductInfo::all();
        $retVal = [];
        foreach ($items as $item) {
            $retVal[$item->sku] = $item;
        }
        return $retVal;
    }

    public function getProductBySkuIds($productIds = []) {
        if (empty($productIds)) {
            $items = ProductInfo::all();
        } else {
            $items = ProductInfo::whereIn('product_id', $productIds)
                                ->get();
        }
        $retVal = [];
        foreach ($items as $item) {
            $key = $item->product_id;
            if ($item->product_sku_id != null) {
                $key .= '_' . $item->product_sku_id;
            } 
            $retVal[$key] = $item;
        }
        return $retVal;
    }

    public function getSkuById($productIds = []) {
        $chunkProductIds = array_chunk($productIds, 500);
        $itemByIds = [];
        $itemBySkuIds = [];
        foreach ($chunkProductIds as $productIds) {
            $items = DB::table('product_sku')
                        ->whereIn('product_id', $productIds)
                        ->get(['product_id', 'sku', 'is_default', 'id']);
            foreach ($items as $item) {
                $itemBySkuIds[$item->id] = $item->sku;
                if ($item->is_default) {
                    $itemByIds[$item->product_id] = $item->sku;
                }
            }
        }
        
        return [
            'buyIds' => $itemByIds,
            'buySkuIds' => $itemBySkuIds
        ];
    }

    public function getProductByFeed($filter) {
        $query = ProductInfo::leftJoin('product', 'product.id', '=', 'product_info.product_id')
                                ->where('product.status', '=', 'ACTIVE');
        if ($filter['is_push_feed']) {
            $query->where('product.approve_advertising', '=', 1);
        } else {
            $query->where('product.approve_advertising', '=', 0);
        }

        if (isset($filter['codes']) && !empty($filter['codes'])) {
            $query->where('product_info.sku', $filter['codes']);
        }
        if (isset($filter['product_ids']) && !empty($filter['product_ids'])) {
            $query->where('product_info.product_id', filter['product_ids']);
        }
        $items = $query->get();
        return $items;
    }
    
}