<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductNCategory;
use DB;

class ProductNCategoryService extends Service {
    const MODEL = ProductNCategory::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return ProductNCategory::findOrFail($filter['id']);
        }
        $query = ProductNCategory::query();

        if (array_key_exists('category_id', $filter)) {
            $query->where('category_id', $filter['category_id']);
        }

        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_n_category.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }

    public function getProductIds($categoryIds) {
        $items = ProductNCategory::whereIn('category_id', $categoryIds)->get();
        $retVal = [];
        foreach ($items as $item) {
            if (!in_array($item->product_id, $retVal)) {
                $retVal[] = $item->product_id;
            }
        }
        return $retVal;
    }
    
}