<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\Product;
use DB;

class ProductService extends Service {
    const MODEL = Product::class;

    public function find($filter = []) {
        if (array_key_exists('id', $filter)) {
            return Product::findOrFail($filter['id']);
        }
        $query = Product::query();
        if (array_key_exists('skus', $filter) && !empty($filter['skus'])) {
            $query->whereIn('sku', $filter['skus']);
        }
        if (array_key_exists('ids', $filter) && !empty($filter['ids'])) {
            $query->whereIn('id', $filter['ids']);
        }
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }
    
}