<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductToAdvertisingAd;
use DB;

class ProductToAdvertisingAdsService extends Service {
    const MODEL = ProductToAdvertisingAd::class;

    public function find($filter = []) {

        if (array_key_exists('id', $filter)) {
            return ProductToAdvertisingAd::findOrFail($filter['id']);
        }
        $query = ProductToAdvertisingAd::query();
        
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_to_advertise.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }

    public function truncate() {
        ProductToAdvertisingAd::query()->truncate();
    }
    
}