<?php
namespace Modules\Ads\Services;


use Modules\Ads\Models\ProductToAdvertising;
use DB;

class ProductToAdvertisingService extends Service {
    const MODEL = ProductToAdvertising::class;

    public function find($filter = []) {


        if (array_key_exists('id', $filter)) {
            return ProductToAdvertising::findOrFail($filter['id']);
        }
        $query = ProductToAdvertising::query();
        if (array_key_exists('!skus', $filter) && !empty($filter['!skus'])){
            $query->whereNotIn('product_to_advertise.sku', $filter['!skus']);
        }
        if (array_key_exists('!productIds', $filter) && !empty($filter['!productIds'])){
            $query->whereNotIn('product_to_advertise.product_id', $filter['!productIds']);
        }
        if(array_key_exists("keyword", $filter)) {
            $query->where(function($query) use ($filter){
                $query->where('product_to_advertise.title', 'LIKE', '%'.$filter["keyword"].'%')
                    ->orWhere('product_to_advertise.sku', 'LIKE', '%'.$filter["keyword"].'%');
            });
        }
        if (isset($filter['codes']) && is_array($filter['codes'])) {
            $query->whereIn('product_to_advertise.sku', $filter['codes']);
        }
        if (array_key_exists('productIds', $filter) && !empty($filter['productIds'])){
            $query->whereIn('product_to_advertise.product_id', $filter['productIds']);
        }
        if (isset($filter['account_key']) || isset($filter['campaign_type'])
            || isset($filter['ad_type']) || isset($filter['campaign_id'])
        ) {
            $query->leftJoin('product_to_advertise_ads as ptaa', 'ptaa.pta_id', '=', 'product_to_advertise.id');
            if (isset($filter['account_key']) && $filter['account_key'] != '') {
                $query->where('ptaa.account_key', '=', $filter['account_key']);
            }
            if (isset($filter['campaign_type']) && $filter['campaign_type'] != '') {
                $query->where('ptaa.campaign_type', '=', $filter['campaign_type']);
            }
            if (isset($filter['ad_type']) && $filter['ad_type'] != '') {
                $query->where('ptaa.ad_type', '=', $filter['ad_type']);
            }
            if (isset($filter['campaign_id']) && $filter['campaign_id'] != '') {
                $query->where('ptaa.campaign_id', '=', $filter['campaign_id']);
            }
        }
        if (array_key_exists("status", $filter) && $filter["status"] != '') {
            $query->where("product_to_advertise.status", "=", $filter["status"]);
        }
        
        // if (isset($filter['stock'])) {
        //     if ($filter['stock'] == 'in_stock') {
        //         $query->where('inventory', '>', 0);
        //     } elseif ($filter['stock'] == 'out_of_stock') {
        //         $query->where('inventory', '=', 0);
        //     }
        // }
        if (array_key_exists('with', $filter)) {
            $query->with($filter['with']);
        }

        if (array_key_exists('columns', $filter)) {
            $query->select(DB::raw($filter['columns']));
        } else {
            $query->select(DB::raw('sb_product_to_advertise.*'));
        }
        return $this->executeQuery($query, $filter);
        
    }
    
}