<?php
namespace Modules\Ads\Services;

class Service {

    public function create($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $retVal = call_user_func(static::MODEL . '::create');
        foreach($args as $key => $value) {
            $retVal->{$key} = $value;
        }
        $retVal->save();
        return $retVal;
    }

    public function update($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        if (!isset($args["id"])) {
            throw new \InvalidArgumentException('Missing id field');
        }
        $retVal = (call_user_func(static::MODEL . '::find', $args["id"]));
        if (!$retVal) {
            throw new \InvalidArgumentException('Object is empty');
        }
        foreach($args as $key => $value) {
            $retVal->{$key} = $value;
        }
        $retVal->save();
        return $retVal;
    }

    public function updateByField($args = null, $data = null) {
        if ($args == null || $data == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        $retVal = $builder->update($data);
        return $retVal;
    }

    public function delete($id = null) {
        if ($id == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        if (!is_array($id)) {
            $builder = (call_user_func(static::MODEL . '::where', ['id' => $id]));
            $retVal = $builder->delete();
        } else {
            $builder = (call_user_func(static::MODEL . '::query'));
            $retVal = $builder->whereIn('id', $id)->delete();
        }
        return $retVal;
    }

    public function deleteByFields($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        return $builder->delete();
    }

    public function checkExists($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        return $builder->exists();
    }

    public function count($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        return $builder->count();
    }

    public function getFirst($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        return $builder->first();
    }

    public function getLast($args = null) {
        if ($args == null) {
            throw new \InvalidArgumentException('Missing argument');
        }
        $builder = (call_user_func(static::MODEL . '::query'));
        foreach ($args as $key => $value) {
            $builder->where($key, '=', $value);
        }
        return $builder->last();
    }

    //call a static function of Model
    public function callStaticModelFunc() {
        $retVal = false;
        $numargs = func_num_args();
        $arglist = func_get_args();
        if ($numargs == 0) {
            throw new \InvalidArgumentException('Missing argument');
        } else if ($numargs == 1) {
            $retVal = call_user_func(static::MODEL . '::' . $arglist[0]);
        } else if ($numargs == 2) {
            $retVal = call_user_func(static::MODEL . '::' . $arglist[0], $arglist[1]);
        } else if ($numargs >= 3) {
            $argsOfFunc = [];
            for ($i = 1; $i <= count($arglist) - 1; $i++) {
                $argsOfFunc[] = $arglist[$i];
            }
            $retVal = call_user_func_array(static::MODEL . '::' . $arglist[0], $argsOfFunc);
        }
        return $retVal;
    }

    protected function executeQuery($query, $filter) {
        if (array_key_exists('orders', $filter) && count($filter['orders']) > 0) {
            foreach ($filter['orders'] as $key => $value) {
                $query->orderBy($key, $value);
            }
        }
        if (array_key_exists('pageId', $filter) && array_key_exists('pageSize', $filter) && $filter['pageId'] != -1) {
            $query->forPage($filter['pageId'] + 1, $filter['pageSize']);
        }
        if (array_key_exists('metric', $filter) && $filter['metric'] == 'count') {
            return $query->count();
        } else {
            return $query->get();
        }
    }

    protected function readFile($filePath = null, $sheetIdx = 0, $returnFileObject = FALSE) {
        $retval = array();
        $filePath == null ? [] : $filePath;
//  Read your Excel workbook
        try {
            $inputFileType = \PHPExcel_IOFactory::identify($filePath);
            $objReader = \PHPExcel_IOFactory::createReader($inputFileType);
            $objPHPExcel = $objReader->load($filePath);
        } catch (Exception $e) {
            die('Error loading file "' . pathinfo($filePath, PATHINFO_BASENAME) . '": ' . $e->getMessage());
        }

//  Get worksheet dimensions
        $sheet = $objPHPExcel->getSheet($sheetIdx);
        $highestRow = $sheet->getHighestRow();
        $highestColumn = $sheet->getHighestColumn();

//  Loop through each row of the worksheet in turn
        for ($row = 1; $row <= $highestRow; $row++) {
            //  Read a row of data into an array
            $rowData = $sheet->rangeToArray('A' . $row . ':' . $highestColumn . $row, NULL, TRUE, FALSE);
            $retval[] = $rowData[0];
        }
        if ($returnFileObject) {
            return array("docObject" => $objPHPExcel, "sheetObject" => $sheet, "data" => $retval);
        } else {
            return $retval;
        }
    }

    public function recordsCountToPagesCount($recordsCount, $pageSize)
    {
        $retVal = (int)($recordsCount / $pageSize);
        if ($recordsCount % $pageSize > 0) {
            $retVal++;
        }
        //return
        return $retVal;
    }

    public function excecuteStatement($property, $data) {
        $condition = $this->buildCondition($property);
        $values = $this->buildValueList($property, $data);
        $sql = $this->buildSqlStatement($property, $values, $condition);
        return \DB::statement($sql);
    }

    private function buildSqlStatement($property, $value, $condition) {
        return 'INSERT INTO `' . $property['table'] . '` (' . implode(', ', $property['columns']) . ') VALUES '
        . $value . ' ON DUPLICATE KEY UPDATE ' . $condition . ';';
    }

    private function buildCondition($property) {
        $retVal = '';
        for ($i = 0; $i < count($property['columns']); $i++) {
            $retVal .= $property['columns'][$i] . ' = VALUES(' . $property['columns'][$i] . ')';
            if ($i < count($property['columns']) - 1) {
                $retVal .= ', ';
            }
        }
        return $retVal;
    }

    private function buildValueList($property, $data) {
        $value = '';
        for ($j = 0; $j < count($data); $j++) {
            $value .= '(';
            for ($i = 0; $i < count($property['columns']); $i++) {
                $valueTarget = $data[$j][$property['columns'][$i]];
                if (is_string($property['columns'][$i]) || empty($property['columns'][$i])) {
                    $valueTarget = '"' . $valueTarget . '"';
                }
                $value .= $valueTarget;
                if ($i < count($property['columns']) - 1) {
                    $value .= ', ';
                }
            }
            $value .= ')';
            if ($j < count($data) - 1) {
                $value .= ',';
            }
        }
        return $value;
    }
}