<?php
Module::onView('title', function ($data) {
    return $data['page'] . ': This is title from Ads Module';
}, 10);
Module::onView('header', function ($data) {
    return view('ads::includes.header', [
        'moduleHeader' => getModuleOption('option.header'),
    ]);
}, 10);
Module::onView('content', function ($data) {
    return 'This is content view from Ads Module';
});

Module::onView('system.menu', function () {
    return view('ads::includes.menu');
});

Module::onView('system.inc.product-ads-config', function () {
    return view('ads::product.ads-config');
});

## ONVIEW EVENT OF FUNCTION PRODUCT TO ADVERTISE ##
Module::onView('system.product-advertise.filters', function ($data) {
    return view('ads::product-advertise.filters')->render();
}, 10);

Module::onView('system.product-advertise.lists', function ($data) {
    return view('ads::product-advertise.list')->render();
}, 10);

Module::onView('system.includes.paginator', function ($data) {
    return view('ads::includes.paginator', $data)->render();
}, 10);

## ONVIEW EVENT OF FUNCTION PRODUCT REACTION ## 

Module::onView('system.product-react.filters', function ($data) {
    return view('ads::product-react.filters');
}, 10);
Module::onView('system.product-react.lists', function ($data) {
    return view('ads::product-react.list');
}, 10);

Module::onView('system.product-category.filters', function ($data) {
    return view('ads::product-category.filters');
}, 10);
Module::onView('system.product-category.lists', function ($data) {
    return view('ads::product-category.list')->render();
}, 10);

//ApproveAdvertising
Module::onView('system.advertising.filter', function ($data) {
    return view('ads::advertising.filter');
}, 5);
Module::onView('system.advertising.list', function ($data) {
    return view('ads::advertising.list');
}, 5);
Module::onView('system.advertising.modal', function ($data) {
    return view('ads::advertising.modal');
}, 5);
Module::onView('system.approve-advertising-btn', function ($data) {
    return view('ads::advertising.approve-btn');
});
Module::onView('system.menu', function () {
    return view('ads::advertising.menu');
});

Module::onVariable('system.menu', function (&$data) {
    if (hasPermission('ads')) {
        $locale = env('APP_LOCALE', '');
        if ($locale !== '') {
            $locale = '/' . $locale;
        }
        foreach ($data as &$item) {
            if ($item['url'] == '/admin/products') {
                $item['children'][] = [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Duyệt sản phẩm theo link',
                    'url' => $locale . '/ads/approve-by-link',
                ];
                $item['children'][] = [
                    'icon' => '<i class="fa fa-users"></i>',
                    'title' => 'Duyệt Ads sản phẩm',
                    'url' => $locale . '/ads/approve-products',
                ];
            }
        }
    }
});

Module::onView('system.report-device.filters', function ($data) {
    return view('ads::report-device.filters')->render();
}, 10);

Module::onView('system.report-device.lists', function ($data) {
    return view('ads::report-device.list')->render();
}, 10);


Module::onView('system.report-product.filters', function ($data) {
    return view('ads::report-product.filters');
}, 10);
Module::onView('system.report-product.lists', function ($data) {
    return view('ads::report-product.list');
}, 10);

Module::onView('system.incorrect-language.list', function ($data) {
    return view('ads::incorrect-language.list');
}, 5);

Module::onView('system.incorrect-language.import', function ($data) {
    return view('ads::incorrect-language.import');
}, 5);

Module::onView('system.incorrect-language.translation', function ($data) {
    return view('ads::incorrect-language.translation');
}, 5);

Module::onView('system.incorrect-language.filter', function ($data) {
    return view('ads::incorrect-language.filter');
}, 5);