<?php

namespace Modules\Amz\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function fromCamelCase($input) {
        preg_match_all('!([A-Z][A-Z0-9]*(?=$|[A-Z][a-z0-9])|[A-Za-z][a-z0-9]+)!', $input, $matches);
        $ret = $matches[0];
        foreach ($ret as &$match) {
          $match = $match == strtoupper($match) ? strtolower($match) : lcfirst($match);
        }
        return implode('_', $ret);
    }

    protected function convertArrayToHearder($headers) {
        $retVal = [];
        foreach ($headers as $key => $value) {
           $retVal[] = $key . ': ' . $value;
        }
        return $retVal;
     }
  
     protected function toDateTimeQuery($value)
     {
         if ($value instanceof \DateTime) { // datetime in ISO8601 format
             return $value->format(\DateTime::ATOM);
         } else {
             return $value;
         }
     }
     
     protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = [])
      {
          $ch = curl_init();
          $timeout = 90;
          curl_setopt($ch, CURLOPT_URL, $url);
          curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
          if ($headers) {
              curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
          }
          if ($method != 'GET') {
              curl_setopt($ch, CURLOPT_POST, 1);
              curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
          }
  
          curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
          $data = curl_exec($ch);
          curl_close($ch);
          return json_decode($data, true);
      }
}
