<?php

namespace Modules\Amz\Controllers;

use Illuminate\Http\Request;
use Modules\Amz\Controllers\Controller;
use Module;
use Modules\Amz\Services\AuthService;
use Modules\Amz\Services\Configuration;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Psr7\Query;
use Modules\Amz\Models\AmzInventory;
use Modules\Amz\Models\Product;
use Modules\Amz\Models\ProductSku;
use Modules\Amz\Models\ProductInfo;

class InventoryController extends Controller
{
    protected $authService = null;

    public function __construct(AuthService $authService)
    {        
       $this->authService = $authService;
    }

    public function getInventory() {
        ini_set("memory_limit", "-1");
        set_time_limit(0);
        $uri = '/fba/inventory/v1/summaries';   
        $this->getResult($uri);
        $this->updateInventory();
        return response()->json(['status' => 'successful']);
    }

    public function getResult($uri, $nexToken = null){
        try {
            $headerAndQueryString = $this->getQueryAndHeader($uri, $nexToken);
            $headers = $headerAndQueryString['headers'];
            $queryString = $headerAndQueryString['queryString'];
            $url = 'https://sellingpartnerapi-na.amazon.com' . $uri . '?' . $queryString;
            $response = $this->triggerSyncRequest($url, 'GET', [], $headers);
            if (isset($response['pagination']['nextToken']) && $response['pagination']['nextToken'] != '') {
                $this->getResult($uri, $response['pagination']['nextToken']);
            }
            if ($response && isset($response['payload']['inventorySummaries'])) {
                $items = [];
                foreach($response['payload']['inventorySummaries'] as $item) {
                    $data = [];
                    $data['asin'] = $item['asin'];
                    $data['fn_sku'] = $item['fnSku'];
                    $data['seller_sku'] = $item['sellerSku'];
                    $data['condition'] = $item['condition'];
                    $data['product_name'] = $item['productName'];
                    $data['total_quantity'] = $item['totalQuantity'];
                    $data['last_update'] = new \DateTime($item['lastUpdatedTime']);
                    $data['fulfillable_quantity'] = (isset($item['inventoryDetails']['fulfillableQuantity'])) ? $item['inventoryDetails']['fulfillableQuantity'] : null;
                    $data['inbound_working_quantity'] = (isset($item['inventoryDetails']['inboundWorkingQuantity'])) ? $item['inventoryDetails']['inboundWorkingQuantity'] : null;
                    $data['inbound_shipped_quantity'] = (isset($item['inventoryDetails']['inboundShippedQuantity'])) ? $item['inventoryDetails']['inboundShippedQuantity'] : null;
                    $data['inbound_receiving_quantity'] = (isset($item['inventoryDetails']['inboundReceivingQuantity'])) ? $item['inventoryDetails']['inboundReceivingQuantity'] : null;
                    $data['total_reserved_quantity'] = (isset($item['inventoryDetails']['reservedQuantity']['totalReservedQuantity'])) ? $item['inventoryDetails']['reservedQuantity']['totalReservedQuantity'] : null;
                    $data['pending_customer_order_quantity'] = (isset($item['inventoryDetails']['reservedQuantity']['pendingCustomerOrderQuantity'])) ? $item['inventoryDetails']['reservedQuantity']['pendingCustomerOrderQuantity'] : null;
                    $data['pending_transshipment_quantity'] = (isset($item['inventoryDetails']['reservedQuantity']['pendingTransshipmentQuantity'])) ? $item['inventoryDetails']['reservedQuantity']['pendingTransshipmentQuantity'] : null;
                    $data['fc_processing_quantity'] = (isset($item['inventoryDetails']['reservedQuantity']['fcProcessingQuantity'])) ? $item['inventoryDetails']['reservedQuantity']['fcProcessingQuantity'] : null;
                    $data['total_researching_quantity'] = (isset($item['inventoryDetails']['researchingQuantity']['totalResearchingQuantity'])) ? $item['inventoryDetails']['researchingQuantity']['totalResearchingQuantity'] : null;
                    $researchingQuantityInShortTerm = null;
                    $researchingQuantityInMidTerm = null;
                    $researchingQuantityInLongTerm = null;
                    if (isset($item['inventoryDetails']['researchingQuantity']['researchingQuantityBreakdown'])) {
                        foreach ($item['inventoryDetails']['researchingQuantity']['researchingQuantityBreakdown'] as $q) {
                            if ($q['name'] == 'researchingQuantityInShortTerm') {
                                $researchingQuantityInShortTerm = $q['quantity'];
                            }
                            if ($q['name'] == 'researchingQuantityInMidTerm') {
                                $researchingQuantityInMidTerm = $q['quantity'];
                            }
                            if ($q['name'] == 'researchingQuantityInLongTerm') {
                                $researchingQuantityInLongTerm = $q['quantity'];
                            }
                        }
                    }
                    $data['researching_quantityIn_short_term'] = $researchingQuantityInShortTerm;
                    $data['researching_quantity_in_mid_term'] = $researchingQuantityInMidTerm;
                    $data['researching_quantity_in_long_term'] = $researchingQuantityInLongTerm;
                    $data['total_unfulfillable_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['totalUnfulfillableQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['totalUnfulfillableQuantity'] : null;
                    $data['customer_damaged_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['customerDamagedQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['customerDamagedQuantity'] : null;
                    $data['warehouse_damaged_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['warehouseDamagedQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['warehouseDamagedQuantity'] : null;
                    $data['distributor_damaged_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['distributorDamagedQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['distributorDamagedQuantity'] : null;
                    $data['carrier_damaged_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['carrierDamagedQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['carrierDamagedQuantity'] : null;
                    $data['defective_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['defectiveQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['defectiveQuantity'] : null;
                    $data['expired_quantity'] = (isset($item['inventoryDetails']['unfulfillableQuantity']['expiredQuantity'])) ? $item['inventoryDetails']['unfulfillableQuantity']['expiredQuantity'] : null;
                    $data['reserved_future_supply_quantity'] = (isset($item['inventoryDetails']['futureSupplyQuantity']['reservedFutureSupplyQuantity'])) ? $item['inventoryDetails']['futureSupplyQuantity']['reservedFutureSupplyQuantity'] : null;
                    $data['future_supply_buyable_quantity'] = (isset($item['inventoryDetails']['futureSupplyQuantity']['futureSupplyBuyableQuantity'])) ? $item['inventoryDetails']['futureSupplyQuantity']['futureSupplyBuyableQuantity'] : null;
                    $items[] = $data;
                }
                foreach($items as $item) {
                    $checkExists = AmzInventory::where('last_update', '=', $item['last_update'])
                                                ->where('seller_sku', '=', $item['seller_sku'])
                                                ->where('fn_sku', '=', $item['fn_sku'])
                                                ->first();
                    if (!$checkExists) {
                        AmzInventory::create($item);
                    }
                }
            }   

        } catch(\Exception $ex) {
            \Log::info('Cron Inventory Amazon Errors: ' . $ex->getMessage());
        }
    }

    private function getQueryAndHeader($uri, $nexToken = null) {
        $queryParams = [
            'marketplaceIds' => 'ATVPDKIKX0DER'
        ];
        $queryParams['details'] = "true";
        $queryParams['granularityType'] = 'Marketplace';
        $queryParams['granularityId'] = 'ATVPDKIKX0DER';
        if ($nexToken != null) {
            $queryParams['nextToken'] = $nexToken;
        }
        ksort($queryParams);
        $queryString = Query::build($queryParams);
        $headers = $this->authService->buildHeader('GET', $uri, $queryString);
        $headers['Accept'] = 'application/json';
        $headers['Content-Type'] = 'application/json';
        $headers = $this->convertArrayToHearder($headers);
        return [
           'headers' => $headers,
           'queryString' => $queryString
        ];
     }

    public function updateInventory() {
        $items = ProductInfo::get(['product_id', 'product_sku_id', 'sku', 'is_variant']);
        $inventoryByProducts = [];
        foreach($items as $product) {
            $inventory = AmzInventory::where('fn_sku', '=', $product->sku)
                                    ->orderBy('last_update', 'DESC')
                                    ->first();
            if ($inventory) {
                $inventoryByProducts[$product->sku] = $inventory->fulfillable_quantity;
            }
        }
        $inventoryByProductIds = [];
        foreach($items as $item) {
            if (isset($inventoryByProducts[$item->sku])) {
                if ($item->is_variant) {
                    if (!isset($inventoryByProductIds[$item->product_id])) {
                        $inventoryByProductIds[$item->product_id] = 0;
                    }
                    $inventoryByProductIds[$item->product_id] += $inventoryByProducts[$item->sku];
                    ProductSku::where('sku', '=', $item->sku)
                                ->update(['inventory' => $inventoryByProducts[$item->sku]]);
                } else {
                    Product::where('sku', '=', $item->sku)
                            ->update(['inventory' => $inventoryByProducts[$item->sku]]);
                }
            }
        }

        foreach ($inventoryByProductIds as $key => $value) {
            Product::where('id', '=', $key)
                    ->update(['inventory' => $value]);
        }

    }

}
