<?php

namespace Modules\Amz\Controllers;

use Illuminate\Http\Request;
use Modules\Amz\Controllers\Controller;
use Module;
use Modules\Amz\Services\AuthService;
use Modules\Amz\Services\Configuration;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Psr7\Query;
use Modules\Amz\Models\AmzOrder;

use PHPExcel;
use PHPExcel_IOFactory;

class OrderController extends Controller
{
    protected $authService = null;

    public function __construct(AuthService $authService)
    {        
       $this->authService = $authService;
    }

   public function getOrder() {
      ini_set("memory_limit", "-1");
      set_time_limit(0);
      $uri = '/orders/v0/orders';
      $this->getResult($uri);
      $response = [
         'status' => 'successful'
      ];
      return response()->json($response);
   }

   public function exportOrder(Request $request) {
      $day = $request->has('days') ? $request->input('days') : 30;
      ini_set("memory_limit", "-1");
      set_time_limit(0);
      $uri = '/orders/v0/orders';
      $result = [];
      $this->getData($uri, $day, null, $result);
      $this->exportExcel($result);
   }

   private function exportExcel($items) {
       /** Build excel file to export */
      $objPHPExcel = new PHPExcel();

      $objPHPExcel->setActiveSheetIndex(0);
      $objPHPExcel->getActiveSheet()->SetCellValue('A1', "");
      $objPHPExcel->getActiveSheet()->SetCellValue('B1', "AmazonOrderId");
      $objPHPExcel->getActiveSheet()->SetCellValue('C1', "EarliestShipDate");
      $objPHPExcel->getActiveSheet()->SetCellValue('D1', "OrderStatus");
      $objPHPExcel->getActiveSheet()->SetCellValue('E1', "LatestShipDate");
      $objPHPExcel->getActiveSheet()->SetCellValue('F1', "PurchaseDate");
      $objPHPExcel->getActiveSheet()->SetCellValue('G1', "StateOrRegion");
      $objPHPExcel->getActiveSheet()->SetCellValue('H1', "PostalCode");
      $objPHPExcel->getActiveSheet()->SetCellValue('I1', "City");
      $objPHPExcel->getActiveSheet()->SetCellValue('J1', "Amount");
      $objPHPExcel->getActiveSheet()->SetCellValue('K1', "LastUpdateDate");
      $objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setBold(true);
      $objPHPExcel->getActiveSheet()->getStyle("A1:K1")->getFont()->setSize(12);
      $i = 1;
      $j = 0;

      foreach ($items as $item) {
         $i++;
         $j++;
         $objPHPExcel->getActiveSheet()->SetCellValue('A' . $i, $j);
         $objPHPExcel->getActiveSheet()->SetCellValue('B' . $i, $item['AmazonOrderId']);
         $objPHPExcel->getActiveSheet()->SetCellValue('C' . $i, $item['EarliestShipDate']);
         $objPHPExcel->getActiveSheet()->SetCellValue('D' . $i, $item['OrderStatus']);
         $objPHPExcel->getActiveSheet()->SetCellValue('E' . $i, $item['LatestShipDate']);
         $objPHPExcel->getActiveSheet()->SetCellValue('F' . $i, $item['PurchaseDate']);
         $stateOrRegion = '';
         $postalCode = '';
         $city = '';
         if (!empty($item['ShippingAddress'])) {
            $stateOrRegion = $item['ShippingAddress']['StateOrRegion'];
            $postalCode = $item['ShippingAddress']['PostalCode'];
            $city = $item['ShippingAddress']['City'];
         }
         $amount = '';
         if (!empty($item['OrderTotal'])) {
            $amount = $item['OrderTotal']['Amount'];
         }
         $objPHPExcel->getActiveSheet()->SetCellValue('G' . $i, $stateOrRegion);
         $objPHPExcel->getActiveSheet()->SetCellValue('H' . $i, $postalCode);
         $objPHPExcel->getActiveSheet()->SetCellValue('I' . $i, $city);
         $objPHPExcel->getActiveSheet()->SetCellValue('J' . $i, $amount);
         $objPHPExcel->getActiveSheet()->SetCellValue('K' . $i, $item['LastUpdateDate']);
      }

      ob_end_clean();
      $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
      header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
      header('Content-Disposition: attachment;filename="Amazon-Export-' . time() . '.xlsx"');
      header('Cache-Control: max-age=0');
      $writer->save('php://output');
      exit;
   }

   private function getData($uri, $day, $nexToken = null, &$result) {
      $headerAndQueryString = $this->getQueryAndHeader($uri, $nexToken, $day);
      $queryString = $headerAndQueryString['queryString'];
      $headers = $headerAndQueryString['headers'];
      $url = 'https://sellingpartnerapi-na.amazon.com' . $uri . '?' . $queryString;
      $response = $this->triggerSyncRequest($url, 'GET', [], $headers);
      if ($response && isset($response['payload'])) {
         if (isset($response['payload']['Orders']) && !empty($response['payload']['Orders'])) {
            $result = array_merge($result, $response['payload']['Orders']);
         }
         if (isset($response['payload']['NextToken']) && $response['payload']['NextToken'] != '') {
            $this->getData($uri, $day, $response['payload']['NextToken'], $result);
         }
      }
   }


   private function getResult($uri, $nexToken = null) {
      try {
         $headerAndQueryString = $this->getQueryAndHeader($uri, $nexToken, 30);
         $queryString = $headerAndQueryString['queryString'];
         $headers = $headerAndQueryString['headers'];
         $url = 'https://sellingpartnerapi-na.amazon.com' . $uri . '?' . $queryString;
         $response = $this->triggerSyncRequest($url, 'GET', [], $headers);
         $responses = [];
         if ($response && isset($response['payload'])) {
            if (isset($response['payload']['NextToken']) && $response['payload']['NextToken'] != '') {
               $this->getResult($uri, $response['payload']['NextToken']);
            }
            if (isset($response['payload']['Orders']) && !empty($response['payload']['Orders'])) {
               $this->saveData($response['payload']['Orders']);
            }
         }
      } catch (\Exception $ex) {
         \Log::info('Cron Order Amazon Errors: ' . $ex->getMessage());
      }
      
   }

   private function saveData($orders) {
      $saveData = [];
      $ignoreConvertColumns = ['OrderTotal', 'PaymentMethodDetails'];
      $columns = ['AmazonOrderId', 'PurchaseDate', 'LastUpdateDate', 'OrderStatus', 'SellerOrderId',
                  'FulfillmentChannel', 'SalesChannel', 'ShipServiceLevel', 'NumberOfItemsShipped',
                  'NumberOfItemsUnshipped', 'PaymentMethod', 'IsReplacementOrder', 'MarketplaceId',
                  'ShipmentServiceLevelCategory', 'OrderType', 'EarliestShipDate', 'LatestShipDate',
                  'IsBusinessOrder', 'IsSoldByAB', 'IsPrime', 'IsGlobalExpressEnabled', 'IsPremiumOrder',
                  'IsISPU', 'DefaultShipFromLocationAddress'
               ];
      foreach ($orders as $order) {
         $data = [];
         foreach ($order as $key => $value) {
            if (in_array($key, $columns) && !in_array($key, $ignoreConvertColumns)) {
               $column = $this->fromCamelCase($key);
               $data[$column] = $value;
            }
            if ($key == 'OrderTotal') {
               $data['amount'] = $value['Amount'];
               $data['currency_code'] = $value['CurrencyCode'];
            }
            if ($key == 'PaymentMethodDetails' && !empty($value)) {
               $data['payment_method_details'] = $value[0];
            }
         }
         $saveData[] = $data;
      }
      $this->createOrUpdate($saveData);
   }

   private function createOrUpdate($saveData) {
      foreach ($saveData as $item) {
         $save = [];
         foreach ($item as $key => $value) {
            $save[$key] = $value;
            if (strpos($key, 'is_') !== false && strpos($key, 'is_') === 0 && ($value != null || $value != '')) {
               $save[$key] = (int)filter_var($value, FILTER_VALIDATE_BOOLEAN);
            }
            if (strpos($key, 'date') !== false) {
               $save[$key] = new \DateTime($value);
            }
         }
         $checkExists = AmzOrder::where('amazon_order_id', '=', $save['amazon_order_id'])
                                 ->exists();
         if (!$checkExists) {
            AmzOrder::create($save);
         } else {
            AmzOrder::where('amazon_order_id', '=', $save['amazon_order_id'])
                     ->update($save);
         }
      }
   }

   private function getQueryAndHeader($uri, $nexToken = null, $day) {
      $queryParams = [
         'MarketplaceIds' => 'ATVPDKIKX0DER'
      ];
      $createdAfter = date('Y-m-d', strtotime('-' . $day . ' days'));
      $createdAfter = $this->toDateTimeQuery($createdAfter);
      $queryParams['CreatedAfter'] = $createdAfter;
      if ($nexToken != null) {
         $queryParams['NextToken'] = $nexToken;
      }
      ksort($queryParams);
      $queryString = Query::build($queryParams);
      $headers = $this->authService->buildHeader('GET', $uri, $queryString);
      $headers['Accept'] = 'application/json';
      $headers['Content-Type'] = 'application/json';
      $headers = $this->convertArrayToHearder($headers);
      return [
         'headers' => $headers,
         'queryString' => $queryString
      ];
   }
}
