<?php

namespace Modules\Amz\Controllers;

use Illuminate\Http\Request;
use Modules\Amz\Controllers\Controller;
use Module;
use Modules\Amz\Services\AuthService;
use Modules\Amz\Services\Configuration;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Psr7\Query;
use Modules\Amz\Models\AmzOrder;
use Modules\Amz\Models\AmzOrderItem;


class OrderItemController extends Controller
{
    protected $authService = null;

    public function __construct(AuthService $authService)
    {        
       $this->authService = $authService;
    }

   public function getOrderItem() {
      ini_set("memory_limit", "-1");
      set_time_limit(0);
      $first = AmzOrder::where('is_get_order_item', '=', 0)
                        ->first();
      if ($first) {
         $this->getItems($first, 'get_item');
      }
      $shippedFirst = AmzOrder::where('is_get_order_item', '=', 1)
                              ->where('order_status', '=', 'Shipped')
                              ->where('is_get_item_order_shipped', '=', 0)
                              ->first();
      if ($shippedFirst) {
         $this->getItems($shippedFirst, 'update_item');
      }
      $response = ['status' => 'successful'];
      return response()->json($response);
      
   }

   private function getItems($order, $type) {
      $uri = '/orders/v0/orders/' . $order->amazon_order_id . '/orderItems';
      $headers = $this->authService->buildHeader('GET', $uri);
      $headers['Accept'] = 'application/json';
      $headers['Content-Type'] = 'application/json';
      $headers = $this->convertArrayToHearder($headers);
      $url = 'https://sellingpartnerapi-na.amazon.com' . $uri;
      $response = $this->triggerSyncRequest($url, 'GET', [], $headers);
      if ($response && isset($response['payload']) && !empty($response['payload']['OrderItems'])) {
         $items = [];
         foreach ($response['payload']['OrderItems'] as $item) {
            $data = [];
            $data['order_id'] = $order->id;
            $data['asin'] = $item['ASIN'];
            $data['order_item_id'] = $item['OrderItemId'];
            $data['seller_sku'] = $item['SellerSKU'];
            $data['title'] = $item['Title'];
            $data['quantity_ordered'] = $item['QuantityOrdered'];
            $data['quantity_shipped'] = $item['QuantityShipped'];
            $data['shipping_price'] = (isset($item['ShippingPrice']['Amount'])) ? $item['ShippingPrice']['Amount'] : null;
            $data['shipping_tax'] = (isset($item['ShippingTax']['Amount'])) ? $item['ShippingTax']['Amount'] : null;
            $data['shipping_discount'] = (isset($item['ShippingDiscount']['Amount'])) ? $item['ShippingDiscount']['Amount'] : null;
            $data['shipping_discount_tax'] = (isset($item['ShippingDiscountTax']['Amount'])) ? $item['ShippingDiscountTax']['Amount'] : null;
            $data['product_info_number_of_items'] = (isset($item['ProductInfo']['NumberOfItems'])) ? $item['ProductInfo']['NumberOfItems'] : null;
            $data['item_price'] = (isset($item['ItemPrice']['Amount'])) ? $item['ItemPrice']['Amount'] : null;
            $data['tax_collection_model'] = (isset($item['TaxCollection']['Model'])) ? $item['TaxCollection']['Model'] : null;
            $data['tax_collection_responsible_party'] = (isset($item['TaxCollection']['ResponsibleParty'])) ? $item['TaxCollection']['ResponsibleParty'] : null;
            $data['item_tax'] = (isset($item['ItemTax']['Amount'])) ? $item['ItemTax']['Amount'] : null;
            $data['promotion_discount'] = (isset($item['PromotionDiscount']['Amount'])) ? $item['PromotionDiscount']['Amount'] : null;
            $data['promotion_discount_tax'] = (isset($item['PromotionDiscountTax']['Amount'])) ? $item['PromotionDiscountTax']['Amount'] : null;
            $data['promotion_ids'] = (isset($item['PromotionIds']) && !empty($item['PromotionIds'])) ? implode(',', $item['PromotionIds']) : null;
            $data['is_gift'] = (int)filter_var($item['IsGift'], FILTER_VALIDATE_BOOLEAN);
            $data['is_transparency'] = $item['IsTransparency'];
            $items[] = $data;
         }
         foreach ($items as $item) {
            $exists = AmzOrderItem::where('order_item_id', '=', $item['order_item_id'])
                           ->exists();
            if (!$exists) {
               AmzOrderItem::create($item);
            } else {
               AmzOrderItem::where('order_item_id', '=', $item['order_item_id'])
                                 ->update($item);
            }
         }
         if ($type == 'get_item') {
            $order->is_get_order_item = 1;
         }
         if ($type == 'update_item') {
            $order->is_get_item_order_shipped = 1;
         }
         $order->save();
      }
   }
}
