<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateAmzOrderItemTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('amz_order')) {
            Schema::create('amz_order_item', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('order_id')->nullable();
                $table->string('asin', 12)->nullable();
                $table->string('seller_sku', 14)->nullable();
                $table->string('order_item_id', 20)->nullable();
                $table->string('title', 255)->nullable();
                $table->tinyInteger('quantity_ordered')->nullable();
                $table->tinyInteger('quantity_shipped')->nullable();
                $table->tinyInteger('product_info_number_of_items')->nullable();
                $table->float('item_price')->nullable();
                $table->float('shipping_price')->nullable();
                $table->string('tax_collection_model', 255)->nullable();
                $table->string('tax_collection_responsible_party', 255)->nullable();
                $table->float('item_tax')->nullable();
                $table->float('shipping_tax')->nullable();
                $table->float('shipping_discount')->nullable();
                $table->float('shipping_discount_tax')->nullable();
                $table->float('promotion_discount')->nullable();
                $table->float('promotion_discount_tax')->nullable();
                $table->string('promotion_ids', 255)->nullable()->default('');
                $table->tinyInteger('is_gift')->nullable()->default(0);
                $table->tinyInteger('is_transparency')->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('order_id', 'order_id');
                $table->index('order_item_id', 'order_item_id');
                
                $table->charset = 'latin1';
                $table->collation = 'latin1_swedish_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amz_order_item');
    }
}
