<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateAmzOrderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('amz_order')) {
            Schema::create('amz_order', function (Blueprint $table) {
                $table->increments('id');
                $table->string('amazon_order_id', 22)->nullable();
                $table->string('seller_order_id', 22)->nullable();
                $table->dateTime('purchase_date')->nullable();
                $table->dateTime('last_update_date')->nullable();
                $table->string('order_status', 12)->nullable();
                $table->string('fulfillment_channel', 8)->nullable();
                $table->string('sales_channel', 32)->nullable();
                $table->string('order_channel', 8)->nullable();
                $table->string('ship_service_level', 12)->nullable();
                $table->float('amount')->nullable();
                $table->string('currency_code', 4)->nullable();
                $table->string('order_type', 20)->nullable();
                $table->dateTime('earliest_ship_date')->nullable();
                $table->dateTime('latest_ship_date')->nullable();
                $table->tinyInteger('is_business_order')->nullable();
                $table->tinyInteger('is_replacement_order')->nullable();
                $table->string('payment_method', 8)->nullable();
                $table->string('payment_method_details', 12)->nullable();
                $table->string('shipment_service_level_category', 12)->nullable();
                $table->tinyInteger('number_of_items_shipped')->nullable();
                $table->tinyInteger('number_of_items_unshipped')->nullable();
                $table->string('marketplace_id', 24)->nullable();
                $table->tinyInteger('is_prime')->nullable();
                $table->tinyInteger('is_global_express_enabled')->nullable();
                $table->tinyInteger('is_premium_order')->nullable();
                $table->tinyInteger('is_ispu')->nullable();
                $table->tinyInteger('is_sold_by_ab')->nullable();
                $table->tinyInteger('is_get_order_item')->nullable()->default(0);
                $table->integer('is_get_item_order_shipped')->nullable()->default(0);
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                $table->index('amazon_order_id', 'amazon_order_id');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amz_order');
    }
}
