<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Migration auto-generated by Sequel Pro/Ace Laravel Export (1.8.1)
 * @see https://github.com/cviebrock/sequel-pro-laravel-export
 */
class CreateAmzInventoryTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('amz_inventory')) {
            Schema::create('amz_inventory', function (Blueprint $table) {
                $table->increments('id');
                $table->string('asin', 32)->nullable();
                $table->string('fn_sku', 32)->nullable();
                $table->string('seller_sku', 32)->nullable();
                $table->string('condition', 32)->nullable();
                $table->string('product_name', 500)->nullable();
                $table->integer('total_quantity')->nullable();
                $table->integer('fulfillable_quantity')->nullable();
                $table->integer('inbound_working_quantity')->nullable();
                $table->integer('inbound_shipped_quantity')->nullable();
                $table->integer('inbound_receiving_quantity')->nullable();
                $table->integer('total_reserved_quantity')->nullable();
                $table->integer('pending_customer_order_quantity')->nullable();
                $table->integer('pending_transshipment_quantity')->nullable();
                $table->integer('fc_processing_quantity')->nullable();
                $table->integer('total_researching_quantity')->nullable();
                $table->integer('researching_quantityIn_short_term')->nullable();
                $table->integer('researching_quantity_in_mid_term')->nullable();
                $table->integer('researching_quantity_in_long_term')->nullable();
                $table->integer('total_unfulfillable_quantity')->nullable();
                $table->integer('customer_damaged_quantity')->nullable();
                $table->integer('warehouse_damaged_quantity')->nullable();
                $table->integer('distributor_damaged_quantity')->nullable();
                $table->integer('carrier_damaged_quantity')->nullable();
                $table->integer('defective_quantity')->nullable();
                $table->integer('expired_quantity')->nullable();
                $table->integer('reserved_future_supply_quantity')->nullable();
                $table->integer('future_supply_buyable_quantity')->nullable();
                $table->dateTime('last_update')->nullable();
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();

                $table->charset = 'utf8';
                $table->collation = 'utf8_general_ci';
            });
        }
        
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('amz_inventory');
    }
}
