<?php


namespace Modules\Amz\Services;

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\RequestOptions;

class AuthService extends Service{

    protected $host = 'sellingpartnerapi-na.amazon.com';
    protected $userAgent = 'cs-php-sp-api-client/2.1';
    protected $account = [];

    public function __construct() {
        $account = \Config::get('amz_auth', []);
        if (empty($account)) {
            throw new \Exception('The module Amz require a file "amz_auth.php" in /config directory');
        }
        $this->account = $account;
    }

    public function getAccessToken() {
        $client = new Client();
        $params = [
            'grant_type' => 'refresh_token',
            'refresh_token' => $this->account['refresh_token'],
            'client_id' => $this->account['client_id'],
            'client_secret' => $this->account['client_secret'],
        ];
        $options = array_merge([
            RequestOptions::HEADERS => ['Accept' => 'application/json'],
            RequestOptions::HTTP_ERRORS => false,
            'curl' => [
                CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_2,
            ],
        ], $params ? [RequestOptions::FORM_PARAMS => $params] : []);

        $response = $client->request('POST', 'https://api.amazon.com/auth/o2/token', $options);

        $body = $response->getBody()->getContents();
        $bodyAsJson = json_decode($body, true);

        return $bodyAsJson['access_token'];
    }

    public function buildHeader($method, $uri, $queryString = '', $data = ''){
        $securityToken = null;
        $terminationString = 'aws4_request';
        $algorithm = 'AWS4-HMAC-SHA256';
        $amzdate = gmdate('Ymd\THis\Z');
        $service = 'execute-api';
        $date = substr($amzdate, 0, 8);
        $accessToken = $this->getAccessToken();
        // Prepare payload
        if (is_array($data)) {
            $param = json_encode($data);
            if ('[]' == $param) {
                $requestPayload = '';
            } else {
                $requestPayload = $param;
            }
        } else {
            $requestPayload = $data;
        }
        
        // Hashed payload
        $hashedPayload = hash('sha256', $requestPayload);
        //Compute Canonical Headers
        $canonicalHeaders = [
            'host' => $this->host,
            'user-agent' => $this->userAgent,
        ];
        // Check and attach access token to request header.
        if (!is_null($accessToken)) {
            $canonicalHeaders['x-amz-access-token'] = $accessToken;
        }
        $canonicalHeaders['x-amz-date'] = $amzdate;
        // Check and attach STS token to request header.
        if (!is_null($securityToken)) {
            $canonicalHeaders['x-amz-security-token'] = $securityToken;
        }
        $canonicalHeadersStr = '';
        foreach ($canonicalHeaders as $h => $v) {
            $canonicalHeadersStr .= $h.':'.$v."\n";
        }
        $signedHeadersStr = join(';', array_keys($canonicalHeaders));
        //Prepare credentials scope
        $credentialScope = $date.'/'.$this->account['region'].'/'.$service.'/'.$terminationString;

        //prepare canonical request
        $canonicalRequest = $method."\n".$uri."\n".$queryString."\n".$canonicalHeadersStr."\n".$signedHeadersStr."\n".$hashedPayload;

        //Prepare the string to sign
        $stringToSign = $algorithm."\n".$amzdate."\n".$credentialScope."\n".hash('sha256', $canonicalRequest);
        //Start signing locker process
        //Reference : https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html
        $kSecret = 'AWS4'.$this->account['secret_key'];
        $kDate = hash_hmac('sha256', $date, $kSecret, true);
        $kRegion = hash_hmac('sha256', $this->account['region'], $kDate, true);
        $kService = hash_hmac('sha256', $service, $kRegion, true);
        $kSigning = hash_hmac('sha256', $terminationString, $kService, true);

        //Compute the signature
        $signature = trim(hash_hmac('sha256', $stringToSign, $kSigning));
        $accessKey = $this->account['access_key'];
        //Finalize the authorization structure
        $authorizationHeader = $algorithm." Credential={$accessKey}/{$credentialScope}, SignedHeaders={$signedHeadersStr}, Signature={$signature}";

        $retVal = array_merge($canonicalHeaders, [
            'Authorization' => $authorizationHeader,
        ]);
        return $retVal;
    }


}

?>