<?php

namespace Modules\Authorization\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function buildPagination($filter, $query) {
        $retVal = [
            'status' => 'successful',
            'result' => [],
            'meta' => [],
        ];

        if (!isset($filter['page_size'])) {
            $filter['page_size'] = 20;
        }
        if (!isset($filter['page_id'])) {
            $filter['page_id'] = 0;
        }

        $total = $query->count();
        $retVal['meta'] = $this->getMetaData($filter, $total);
        if ($filter['page_size'] > 0) {
            $query->limit($filter['page_size']);
            $query->offset($filter['page_size'] * $filter['page_id']);
        }
        $retVal['result'] = $query->get();

        return $retVal;
    }

    protected function getMetaData($data, $total)
    {
        
        if (isset($data['page_size'])) {
            $pageSize = $data['page_size'];
        } else {
            $pageSize = 20;
        }
        if (isset($data['page_id'])) {
            $pageId = $data['page_id'];
        } else {
            $pageId = 0;
        }
        $meta = [
            'page_id' => intval($pageId),
            'page_size' => intval($pageSize),
            'page_count' => 0,
            'has_next' => false,
            'total_count' => $total,
        ];
        $meta['page_count'] = $pageSize > 0 ? ceil($total / $pageSize) : 1;
        if ($pageId < $meta['page_count'] - 1) {
            $meta['has_next'] = true;
        }

        return $meta;
    }
}
