<?php

namespace Modules\Authorization\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Modules\Authorization\Controllers\Controller;
use Modules\Authorization\Models\Permission;
use Illuminate\Support\Facades\Validator;
use Modules\Authorization\Models\RoleNPermission;

class PermissionController extends Controller
{
    public function index(Request $request) {
        return view('authorization::permission');
    }

    public function store(Request $request) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'method' => 'required',
            'value' => 'required',
            'project' => 'required',
        ]);
        if ($validator->fails()) {
            $retVal['status'] = 'fail';
            $retVal['message'] = $validator->errors()->first();
        } else {
            $data = $request->only('type', 'method', 'value', 'project');
            if (gettype($data['method']) == 'array') {
                $data['method'] = implode(',', $data['method']);
                if (strpos($data['method'], '*') !== false) {
                    $data['method'] = '*';
                }
            }
            if (Permission::where($data)->exists()) {
                $retVal['status'] = 'fail';
                $retVal['message'] = __('Permission existed');
            } else {
                $data['value_crc'] = crc32($data['value']);
                Permission::create($data);
            }
        }

        return $retVal;
    }

    public function update(Request $request, $id) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'method' => 'required',
            'value' => 'required',
            'project' => 'required',
        ]);
        $parameters = Route::current()->parameters();
        $id = isset($parameters['permission']) ? $parameters['permission'] : $id;
        if ($validator->fails()) {
            $retVal['status'] = 'fail';
            $retVal['message'] = $validator->errors()->first();
        } else {
            $data = $request->only('type', 'method', 'value', 'project');
            if (gettype($data['method']) == 'array') {
                $data['method'] = implode(',', $data['method']);
                if (strpos($data['method'], '*') !== false) {
                    $data['method'] = '*';
                }
            }
            $permission = Permission::find($id);
            if (!$permission) {
                $retVal['status'] = 'fail';
                $retVal['message'] = __('Permission not found');
            } else {
                if (Permission::where($data)->where('id', '!=', $id)->exists()) {
                    $retVal['status'] = 'fail';
                    $retVal['message'] = __('Permission existed');
                } else {
                    $data['value_crc'] = crc32($data['value']);
                    $permission->fill($data);
                    $permission->save();
                } 
            }
        }

        return $retVal;
    }

    public function findPermissions(Request $request) {
        $query = Permission::query();

        if ($request->get('search')) {
            $query->where('value', 'like', '%' . $request->get('search') . '%');
        }

        return $this->buildPagination($request->all(), $query);
    }

    public function destroy(Request $request, $id) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $permission = Permission::find($id);
        if (!$permission) {
            $retVal['status'] = 'fail';
            $retVal['message'] = __('Permission not found');
        } else {
            $permission->delete();
            RoleNPermission::where('permission_id', $id)->delete();
        }

        return $retVal;
    }
}
