<?php

namespace Modules\Authorization\Controllers;

use Illuminate\Support\Facades\Route;
use Module;
use Illuminate\Http\Request;
use Modules\Authorization\Models\Role;
use Illuminate\Support\Facades\Validator;
use Modules\Authorization\Models\RoleNUser;
use Modules\Authorization\Controllers\Controller;
use Modules\Authorization\Models\RoleNPermission;
use Modules\Authorization\Services\AuthorityService;

class RoleController extends Controller
{
    public function index(Request $request) {
        return view('authorization::role');
    }

    public function store(Request $request) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:role,name',
            'description' => 'required',
        ]);
        if ($validator->fails()) {
            $retVal['status'] = 'fail';
            $retVal['message'] = $validator->errors()->first();
        } else {
            $data = $request->only('name', 'description');

            $role = Role::create($data);
            if ($request->permissions && gettype($request->permissions) == 'array') {
                $permissions = $request->permissions;
            } else {
                $permissions = [];
            }
            $role->permissions()->sync($permissions);
        }

        return $retVal;
    }

    public function update(Request $request, $id) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $parameters = Route::current()->parameters();
        $id = isset($parameters['role']) ? $parameters['role'] : $id;
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:role,name,' . $id,
            'description' => 'required',
        ]);
        if ($validator->fails()) {
            $retVal['status'] = 'fail';
            $retVal['message'] = $validator->errors()->first();
        } else {
            $data = $request->only('name', 'description');
            $role = Role::find($id);
            if (!$role) {
                $retVal['status'] = 'fail';
                $retVal['message'] = __('Role not found');
            } else {
                $role->fill($data);
                $role->save();
                if ($request->permissions && gettype($request->permissions) == 'array') {
                    $permissions = $request->permissions;
                } else {
                    $permissions = [];
                }
                $role->permissions()->sync($permissions);
            }
        }

        return $retVal;
    }

    public function findRoles(Request $request) {
        $query = Role::select('id', 'name', 'description')->with('permissions');
        if (AuthorityService::isManager() && !AuthorityService::isAdmin()) {
            $query->whereIn('id', $this->getRoleFromUser());
        }
        if ($request->get('search')) {
            $query->where('name', 'like', '%' . $request->get('search') . '%');
        }

        return $this->buildPagination($request->all(), $query);
    }

    protected function getRoleFromUser() {
        $user = AuthorityService::getUser();
        return RoleNUser::roleFromUser($user->id);
    }

    public function destroy(Request $request, $id) {
        $retVal = [
            'status' => 'successful',
            'result' => null,
            'message' => ''
        ];
        $role = Role::find($id);
        if (!$role) {
            $retVal['status'] = 'fail';
            $retVal['message'] = __('Role not found');
        } else {
            $role->delete();
            RoleNPermission::where('role_id', $id)->delete();
            RoleNUser::where('role_id', $id)->delete();
        }

        return $retVal;
    }
}
