<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('permission')) {
            Schema::create('permission', function (Blueprint $table) {
                $table->increments('id');
                $table->string('type', 50);
                $table->string('value', 2083);
                $table->string('value_crc', 32)->nullable();
                $table->string('method', 255)->default('*');
                $table->string('project', 255)->default('site');
                $table->dateTime('created_at')->nullable();
                $table->dateTime('updated_at')->nullable();
                
                $table->index('value_crc', 'value_crc');
                
                $table->charset = 'utf8';
                $table->collation = 'utf8_unicode_ci';
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('permission');
    }
}
