<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddStatusToUserTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasColumn('users', 'status'))
        {
            Schema::table('users', function (Blueprint $table)
            {
                $table->enum('status', ['ACTIVE', 'PENDING'])->default('ACTIVE');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if (Schema::hasColumn('users', 'status'))
        {
            Schema::table('users', function (Blueprint $table)
            {
                $table->dropColumn('status');
            });
        }
    }
}
