<?php

namespace Modules\Authorization\Models;
use Illuminate\Database\Eloquent\Model;

class Permission extends Model {
    protected $table = 'permission';

    protected $fillable = [
        'type',
        'value',
        'value_crc',
        'method',
        'project'
    ];

    public function roles() {
        return $this->belongsToMany(Role::class, 'role_n_permission');
    }

    const PROJECT = 'site';

    public static function getPermission($permissionName, $method)
    {
        $permissionsName = self::parsePermissionName($permissionName);
        $permissionCRC = self::permissionToCrc($permissionsName);
        return Permission::query()
            ->where('project', self::PROJECT)
            ->whereIn('value', $permissionsName)
            //->whereIn('value_crc', $permissionCRC)
            ->where(function($where) use ($method) {
                $where->where('method', 'LIKE', '%' . $method . '%')
                    ->orWhere('method', 'LIKE', '%' . strtolower($method) . '%')
                    ->orWhere('method', 'LIKE', '%' . strtoupper($method) . '%')
                    ->orWhere('method', '*')
                    ->orWhereNull('method');
            })
            ->pluck('id')->toArray();
    }

    public static function parsePermissionName($permissionName) {
        $result = [$permissionName];
        if ($permissionName) {
            $permissionExplode = explode('/', $permissionName);
            $flag = [];
            foreach ($permissionExplode as $item) {
                $flag[] = $item;
                $path = implode('/', $flag);
                $result[] = $path . '*';
                $result[] = $path . '/*';
            }
        }
        return $result;
    }

    public static function permissionToCrc($permissions) {
        $result = [];
        foreach ($permissions as $item) {
            $result[] = crc32($item);
        }
        return $result;
    }
}
