<?php

namespace Modules\Authorization\Models;
use Illuminate\Database\Eloquent\Model;

class Role extends Model {
    protected $table = 'role';

    protected $fillable = [
        'name', 'description'
    ];

    public function permissions() {
        return $this->belongsToMany(Permission::class, 'role_n_permission');
    }

    public static function getByName($name) {
        return Role::where('name', $name)->first(['id']);
    }
}
