<?php

namespace Modules\Authorization\Models;
use Illuminate\Database\Eloquent\Model;

class RoleNPermission extends Model {
    protected $table = 'role_n_permission';

    protected $fillable = [
        'role_id',
        'permission_id',
    ];

    public static function roleFromPermission($permissionIds) {
        return RoleNPermission::query()
            ->whereIn('permission_id', $permissionIds)
            ->pluck('role_id')->toArray();
    }
}
