<?php

namespace Modules\Authorization\Models;
use Illuminate\Database\Eloquent\Model;

class RoleNUser extends Model {
    protected $table = 'role_n_user';

    protected $fillable = [
        'role_id',
        'user_id',
    ];

    public static function existsRole($userId, $roles) {
        return RoleNUser::query()
            ->where('user_id', $userId)
            ->whereIn('role_id', $roles)
            ->exists();
    }

    public static function userFromRole($roleIds) {
        return RoleNUser::query()
            ->whereIn('role_id', $roleIds)
            ->pluck('user_id')
            ->toArray();
    }

    public static function roleFromUser($userId) {
        return RoleNUser::query()
            ->where('user_id', $userId)
            ->pluck('role_id')
            ->toArray();
    }

}
