system.controller("PermissionController", PermissionController);

function PermissionController($scope, $http, $rootScope){
    this.__proto__ = new PaginationController($scope, $http, $rootScope);

    $scope.permissions = [];
    $scope.types = [
        'function',
        'url',
        'custom'
    ];

    $scope.projects = [
        'site',
        'api'
    ];

    $scope.methods = [
        '*',
        'GET',
        'POST',
        'PUT',
        'PATCH',
        'DELETE',
    ];

    $scope.search = '';
    $scope.permission = null;
    $scope.isLoading = false;

    $scope.newPermission = function () {
        return {
            type: 'url',
            value: '',
            method: ['*'],
            project: 'site'
        };
    }

    function initialize() {
        $scope.findPermissions();
    }

    $scope.findPermissions = function (refresh = false) {
        if (refresh) {
            $scope.meta.page_id = 0;
        }
        $scope.isLoading = true;
        $http.get('/manage/authorization/permissions/find?page_size=' + $scope.meta.page_size + '&page_id=' + $scope.meta.page_id + '&search=' + $scope.search)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.permissions = response.data.result;
                    $scope.meta = response.data.meta;
                }
                $scope.isLoading = false;
            });
    }

    $scope.showModal = function (permission, type = 'create') {
        if (permission && type == 'update') {
            $scope.permission = angular.copy(permission);
            if ($scope.permission.method) {
                $scope.permission.method = $scope.permission.method.split(',');

                for (let i in $scope.permission.method) {
                    $scope.permission.method[i] = $scope.permission.method[i].trim();
                }
            }

        } else {
            $scope.permission = $scope.newPermission();
        }

        $('#permission-modal').modal('toggle');
    }

    $scope.onChangeValue = function () {
        let value = $scope.permission.value;
        if(value) {
            let url = null;

            try {
                url = new URL(value);
                console.log(url);
                value = url.pathname;
            } catch (error) {
                
            }
            if (value.charAt(0) == '/' || value.charAt(0) == '\\') {
                value = value.substring(1);
            }

            if (value.charAt(value.length - 1) == '/' || value.charAt(value.length - 1) == '\\') {
                value = value.substring(0, value.length - 1);
            }
    
            $scope.permission.value = value;
        }
    }

    $scope.save = function () {
        let url = '/manage/authorization/permissions';
        let data = angular.copy($scope.permission);
        if ($scope.permission.id) {
            url += '/' + $scope.permission.id;
            data._method = 'PATCH';
        }
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Lưu permission thành công');
                    $('#permission-modal').modal('toggle');
                    $scope.findPermissions(!$scope.permission.id);
                } else {
                    toastr.error(response.data.message);
                }
            }, function (error) {
                toastr.error('Lưu permission thất bại');
            });
    }

    $scope.delete = function (permission) {
        $scope.callConfirmModal({
            text: 'xóa permission',
            title: 'Xóa permission',
            arg: permission
        }, function (permission) {
            $http.delete('/manage/authorization/permissions/' + permission.id)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Xóa permission thành công');
                        $scope.findPermissions(true);
                    } else {
                        toastr.error(response.data.message);
                    }
                }, function (error) {
                    toastr.error('Xóa permission thất bại');
                });
        })
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.findPermissions();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.findPermissions();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.findPermissions();
        }
    };


    initialize();
}