system.controller("RoleController", RoleController);

function RoleController($scope, $http, $rootScope){
    this.__proto__ = new PaginationController($scope, $http, $rootScope);

    $scope.roles = [];
    $scope.permissions = [];

    $scope.search = '';
    $scope.searchPermission = '';
    $scope.role = null;
    $scope.checkedAll = false;
    $scope.isLoading = false;

    function initialize() {
        $scope.findRoles();
    }

    $scope.newRole = function () {
        return {
            name: '',
            description: '',
            permissions: []
        };
    }

    $scope.findRoles = function (refresh = false) {
        if (refresh) {
            $scope.meta.page_id = 0;
        }
        $scope.isLoading = true;
        $http.get('/manage/authorization/roles/find?page_size=' + $scope.meta.page_size + '&page_id=' + $scope.meta.page_id + '&search=' + $scope.search)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.roles = response.data.result;
                    $scope.meta = response.data.meta;
                    $scope.isLoading = false;
                }
            })
    }

    $scope.findPermissions = function () {
        return $http.get('/manage/authorization/permissions/find?page_size=0')
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.permissions = response.data.result;
                }
            })
    }

    $scope.showModal = function (role, type = 'create') {
        $scope.resetCheckPermissions();
        if (role && type == 'update') {
            $scope.role = angular.copy(role);
            $scope.findPermissions().then(function () {
                if ($scope.role.permissions) {
                    let count  = 0;
                    for (let item of $scope.role.permissions) {
                        for (let role of $scope.permissions) {
                            if (role.id == item.id) {
                                role.checked = true;
                                count++;
                                break;
                            }
                        }
                    }
                    if (count == $scope.permissions.length) {
                        $scope.checkedAll = true;
                    }
                }
            });
        } else {
            $scope.role = $scope.newRole();
            $scope.findPermissions();
        }

        $('#role-modal').modal('toggle');
    }

    $scope.resetCheckPermissions = function () {
        $scope.checkedAll = false;
        for (let item of $scope.permissions) {
            item.checked = false;
        }
    }

    $scope.save = function () {
        let permissions = $scope.permissions.filter(value => value.checked);
        let data = {
            name: $scope.role.name,
            description: $scope.role.description,
            permissions: [],
        };
        if (permissions.length) {
            for (let item of permissions) {
                data.permissions.push(item.id);
            }
        }

        let url = '/manage/authorization/roles';
        if ($scope.role.id) {
            url += '/' + $scope.role.id;
            data._method = 'PATCH';
        }
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Lưu role thành công');
                    $('#role-modal').modal('toggle');
                    $scope.resetCheckPermissions();
                    $scope.findRoles(!$scope.role.id);
                } else {
                    toastr.error(response.data.message);
                }
            }, function (error) {
                toastr.error('Lưu role thất bại');
            });
    }

    $scope.delete = function (role) {
        $scope.callConfirmModal({
            text: 'xóa role',
            title: 'Xóa role',
            arg: role
        }, function (role) {
            $http.delete('/manage/authorization/roles/' + role.id)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Xóa role thành công');
                        $scope.findRoles();
                    } else {
                        toastr.error(response.data.message);
                    }
                }, function (error) {
                    toastr.error('Xóa role thất bại');
                });
        })
    }

    $scope.toggleCheckAll = function () {
        $scope.checkedAll = !$scope.checkedAll;

        for (let item of $scope.permissions) {
            item.checked = $scope.checkedAll;
        }
    }

    $scope.onCheckItem = function (item) {
        item.checked = !item.checked;

        if (!item.checked) {
            $scope.checkedAll = false;
        } else {
            let permissions = $scope.permissions.filter(value => value.checked);
            if (permissions.length == $scope.permissions.length) {
                $scope.checkedAll = true;
            }
        }
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.findRoles();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.findRoles();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.findRoles();
        }
    };

    initialize();
}