system.controller("UserController", UserController);

function UserController($scope, $http, $rootScope){
    this.__proto__ = new PaginationController($scope, $http, $rootScope);

    $scope.users = [];
    $scope.allUser = [];
    $scope.roles = [];
    $scope.isLoading = false;
    $scope.filter = {
        role: null,
        search: '',
    }
    $scope.searchRole = '';
    $scope.cloneUser = null;
    $scope.statuses = [
        'ACTIVE',
        'PENDING'
    ];

    function initialize() {
        $scope.findUsers();
        $scope.findRoles();
        $scope.findAllUsers();
    }

    $scope.newUser = function () {
        return {
            name: '',
            email: '',
            slug: '',
            password: '',
            status: 'ACTIVE',
            permissions: []
        };
    }

    $scope.findUsers = function (refresh = false) {
        if (refresh) {
            $scope.meta.page_id = 0;
        }
        let params = {
            page_size: $scope.meta.page_size,
            page_id: $scope.meta.page_id,
            search: $scope.filter.search,
        }
        if ($scope.filter.role) {
            params.role = $scope.filter.role;
        }
        let paramQuery = new URLSearchParams(params).toString();
        let url = '/manage/authorization/users/find?' + paramQuery;
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.users = response.data.result;
                    $scope.meta = response.data.meta;
                    $scope.isLoading = false;
                }
            })
    }

    $scope.findAllUsers = function () {
        let params = {
            page_size: 100,
        }
        let paramQuery = new URLSearchParams(params).toString();
        let url = '/manage/authorization/users/find?page_size=-1';
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.allUser = sortByName(response.data.result);
                }
            })
    }

    $scope.findRoles = function () {
        $http.get('/manage/authorization/roles/find?page_size=0')
            .then(function (response) {
                if (response.data.status == 'successful') {
                    let roles = response.data.result;
                    $scope.roles = sortByName(roles);
                }
            })
    }

    $scope.resetCheckRoles = function () {
        $scope.searchRole = '';
        $scope.cloneUser = null;
        $scope.checkedAll = false;
        for (let item of $scope.roles) {
            item.checked = false;
        }
    }

    $scope.showModal = function (user, type = 'create') {
        $scope.resetCheckRoles();
        if (user && type == 'update') {
            $scope.user = angular.copy(user);
            if ($scope.user.roles) {
                let count  = 0;
                for (let item of $scope.user.roles) {
                    for (let role of $scope.roles) {
                        if (role.id == item.id) {
                            role.checked = true;
                            count++;
                            break;
                        }
                    }
                }
                if (count == $scope.roles.length) {
                    $scope.checkedAll = true;
                }
            }
        } else {
            $scope.user = $scope.newUser();
        }

        $('#user-modal').modal('toggle');
    }


    $scope.handleClone = function () {
        let roleIDs = {};
        if ($scope.cloneUser) {
            let roles = $scope.cloneUser.roles;
            if ($scope.allUser) {
                for (let user of $scope.allUser) {
                    if (user.id == $scope.cloneUser.id) {
                        roles = user.roles;
                        break;
                    }
                }
            }
            if (roles && roles.length > 0) {
                for (let r of roles) {
                    roleIDs[r.id] = 1;
                }
                let isCheckAll = true;
                for (let r of $scope.roles) {
                    if (roleIDs[r.id] && roleIDs[r.id] == 1) {
                        r.checked = true;
                    }
                    if (!r.checked) {
                        isCheckAll = false;
                    }
                }
                if (isCheckAll) {
                    $scope.checkedAll = true;
                }
                let message = 'Clone thành công quyền user ' + $scope.cloneUser.name;
                toastr.success(message);
            } else if ($scope.cloneUser.name) {
                let message = 'User ' + $scope.cloneUser.name + ' không có quyền để clone'
                toastr.warning(message);
            }
        }


    }

    $scope.save = function () {
        let roles = $scope.roles.filter(value => value.checked);
        let data = {
            name: $scope.user.name,
            email: $scope.user.email,
            status: $scope.user.status,
            slug: $scope.user.slug,
            roles: [],
        };
        if ($scope.user.password) {
            data.password = $scope.user.password;
        }
        if (roles.length) {
            for (let item of roles) {
                data.roles.push(item.id);
            }
        }

        let url = '/manage/authorization/users';
        if ($scope.user.id) {
            url += '/' + $scope.user.id;
            data._method = 'PATCH';
        }
        $http.post(url, data)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Lưu user thành công');
                    $('#user-modal').modal('toggle');
                    $scope.resetCheckRoles();
                    $scope.findUsers(!$scope.user.id);
                    $scope.findAllUsers();

                } else {
                    toastr.error(response.data.message);
                }
            }, function (error) {
                toastr.error('Lưu user thất bại');
            });
    }

    $scope.delete = function (user) {
        $scope.callConfirmModal({
            text: 'xóa user',
            title: 'Xóa user',
            arg: user
        }, function (user) {
            $http.delete('/manage/authorization/users/' + user.id)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        toastr.success('Xóa user thành công');
                        $scope.findUsers();
                    } else {
                        toastr.error(response.data.message);
                    }
                }, function (error) {
                    toastr.error('Xóa user thất bại');
                });
        })
    }

    $scope.toggleCheckAll = function () {
        $scope.checkedAll = !$scope.checkedAll;

        for (let item of $scope.roles) {
            item.checked = $scope.checkedAll;
        }
    }

    $scope.onCheckItem = function (item) {
        item.checked = !item.checked;

        if (!item.checked) {
            $scope.checkedAll = false;
        } else {
            let roles = $scope.roles.filter(value => value.checked);
            if (roles.length == $scope.roles.length) {
                $scope.checkedAll = true;
            }
        }
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.findUsers();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.findUsers();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.findUsers();
        }
    };

    function sortByName(items) {
        items.sort(function(a, b) {
            if (a.name > b.name) {
                return 1;
            } else if (a.name < b.name) {
                return -1;
            }
            return 0;
        })
        return items;
    }

    initialize();
}