@extends('system.layout.main', [
    'ngController' => 'PermissionController'
])
@section('title')
<title>Quản lí Permission</title>
@endsection
@section('css')
    <style>
        .chosen-container {
            width: 100% !important;
        }

        .chosen-choices {
            min-height: 34px !important;
            border-radius: 3px;
        }

        .chosen-container-multi .chosen-choices li.search-choice {
            line-height: 17px !important;
        }

        .input-group {
            margin-bottom: 20px;
        }
    </style>
@endsection
@section('script')
    <script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
    <script src="{{ Module::asset('/authorization/js/permission-controller.js') }}?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection
@section('content')
<div class="row">
    <div class="col-md-10 col-md-offset-1">
        <div class="content">
            <div class="header">
                <div class="pull-left">
                    <h3 class="">Quản lí Permission</h3>
                </div>
                <div class="clearfix">
                </div>
            </div>
            <div style="padding: 5px;">
                <button 
                    type="button" 
                    name="button" 
                    class="btn btn-success  pull-right add" 
                    ng-click="showModal(null, 'create')"
                >
                    <i class="fa fa-plus"></i> Thêm permission
                </button>
                <a href="/admin/settings">
                    <i class="fa fa-angle-left"></i>
                    Quay lại cài đặt
                </a>
                @include('authorization::inc.permission-modal')
            </div>
            <div class="body" style="margin-top: 15px">
                <div class="box no-border">
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <div class="input-group">
                            <input ng-keyUp="$event.keyCode === 13 && findPermissions(true)" ng-model="search" type="text" class="form-control"
                                placeholder="Nhập value">
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-default " ng-click="findPermissions(true)">
                                    <i class="fa fa-search"></i>
                                    Tìm kiếm
                                </button>
                            </div>
                        </div>
                        <table class="table table-borderless" style="table-layout: fixed;">
                            <thead>
                                <tr>
                                    <th style="width: 200px">Type</th>
                                    <th style="width: 200px">Value</th>
                                    <th style="width: 200px">Method</th>
                                    <th style="width: 200px">Project</th>
                                    <th style="width: 100px" class="text-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="item in permissions" ng-if="!isLoading">
                                    <td>@{{ item.type }}</td>
                                    <td>@{{ item.value }}</td>
                                    <td>@{{ item.method }}</td>
                                    <td>@{{ item.project }}</td>
                                    <td>
                                        <button type="button" class="btn btn-success" title="Sửa" ng-click="showModal(item, 'update')">
                                            <i class="fa fa-pencil" aria-hidden="true"></i>
                                        </button>
                                        <button type="button" class="btn btn-danger" title="Xóa" ng-click="delete(item)">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr ng-if="isLoading">
                                    <td colspan="4" class="text-center">
                                        <div class="empty-contain flex-box align-c flex-c">
                                            <img src="/images/loading.gif" alt="">
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="box-footer clearfix">
                        @include('system.pagination')
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
