@extends('system.layout.main', [
    'ngController' => 'UserController'
])
@section('title')
<title>Quản lí user</title>
@endsection
@section('css')
    <style>
        span.item-role {
            padding: 5px;
            border: 1px solid #e1e1e1;
            margin: 0 5px 5px 5px;
            border-radius: 3px;
            background: #fafafa;
            display: inline-block;
        }

        .input-group {
            margin-bottom: 20px;
        }

        .table-scroll {
            overflow-y: auto;
            max-height: 300px;
        }
        .chosen-container {
            width: calc(100% - 30px) !important;
            margin: 0 15px;
        }

        .chosen-choices {
            padding: 5px !important;
            line-height: 27px !important;
        }

        .chosen-single {
            height: 34px !important;
            padding: 4px !important;
        }

    </style>
@endsection
@section('script')
    <script src="/system/js/controllers/pagination/pagination-controller.js" charset="utf-8"></script>
    <script src="{{ Module::asset('/authorization/js/user-controller.js') }}?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection
@section('content')
<div class="row">
    <div class="col-md-10 col-md-offset-1">
        <div class="content">
            <div class="header">
                <div class="pull-left">
                    <h3 class="">Quản lí user</h3>
                </div>
                <div class="clearfix">
                </div>
            </div>
            <div style="padding: 5px;">
                <button 
                    type="button" 
                    name="button" 
                    class="btn btn-success  pull-right add" 
                    ng-click="showModal(null, 'create')"
                >
                    <i class="fa fa-plus"></i> Thêm user
                </button>
                <a href="/admin/settings">
                    <i class="fa fa-angle-left"></i>
                    Quay lại cài đặt
                </a>
                @include('authorization::inc.user-modal')
            </div>
            <div class="body" style="margin-top: 15px">
                <div class="box no-border">
                    <!-- /.box-header -->
                    <div class="box-body table-responsive">
                        <div class="input-group">
                            <div class="col-md-9">
                                <input ng-keyUp="$event.keyCode === 13 && findUsers(true)" ng-model="filter.search" type="text" class="form-control"
                                    placeholder="Nhập tên, email">
                            </div>
                            <div class="col-md-3">
                                <select ng-options="item.id as item.name for item in roles"
                                        class="form-control"
                                        ng-model="filter.role"
                                        ng-change="findUsers(true)"
                                        style="text-transform: capitalize;">
                                    <option value="" selected>-- <?= __("Select role")?> --</option>
                                </select>
                            </div>
                            <div class="input-group-btn">
                                <button type="button" class="btn btn-default " ng-click="findUsers(true)">
                                    <i class="fa fa-search"></i>
                                    Tìm kiếm
                                </button>
                            </div>

                        </div>
                        <table class="table table-borderless" style="table-layout: fixed;">
                            <thead>
                                <tr>
                                    <th style="width: 200px">Họ tên</th>
                                    <th style="width: 200px">Email</th>
                                    <th style="width: 50px">Status</th>
                                    <th style="width: 200px" class="text-center">Role</th>
                                    <th style="width: 100px" class="text-center"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr ng-repeat="user in users" ng-if="!isLoading">
                                    <td>@{{ user.name }}</td>
                                    <td>@{{ user.email }}</td>
                                    <td>@{{ user.status }}</td>
                                    <td>
                                        <span class="item-role" ng-repeat="item in user.roles">@{{ item.name }}</span>
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-success" title="Sửa" ng-click="showModal(user, 'update')">
                                            <i class="fa fa-pencil" aria-hidden="true"></i>
                                        </button>
                                        <button type="button" class="btn btn-danger" title="Xóa" ng-click="delete(user)">
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr ng-if="isLoading">
                                    <td colspan="4" class="text-center">
                                        <div class="empty-contain flex-box align-c flex-c">
                                            <img src="/images/loading.gif" alt="">
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="box-footer clearfix">
                        @include('system.pagination')
                    </div>
                    <!-- /.box-body -->
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
